% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/semipar_formula.R
\name{bayesGAM}
\alias{bayesGAM}
\title{\code{bayesGAM} fits a variety of regression models using Hamiltonian Monte Carlo}
\usage{
bayesGAM(
  formula,
  random = NULL,
  family = gaussian,
  data,
  offset,
  beta = list(),
  eps = list(),
  lambda = list(),
  a = list(),
  spcontrol = list(qr = TRUE, mvindep = FALSE, ...),
  store_plot_data = FALSE,
  method = "bayesGAMfit",
  ...
)
}
\arguments{
\item{formula}{a \code{\link[stats:formula]{formula}} object describing the model to be fitted.}

\item{random}{(optional) specify a random intercept in the form '~var'}

\item{family}{distribution and link function for the model}

\item{data}{(optional) data frame containing the variables in the model.}

\item{offset}{Same as \code{\link[stats:glm]{glm}}}

\item{beta}{(optional) list of priors for the fixed effects parameters.  Sensible priors are selected as a default.}

\item{eps}{(optional) list of priors for the error term in linear regression.  Sensible priors are selecteda as a default.}

\item{lambda}{(optional) list of priors for random effects variance parameters.  Sensible priors are selected as a default.}

\item{a}{(optional) list of priors for the off diagonal of the LDLT decomposed covariance matrix for multivariate response models.  Vague normal priors are used as a default.}

\item{spcontrol}{a list of control parameters for fitting the model in STAN.  See 'details'}

\item{store_plot_data}{a logical indicator for storing the plot data frame after simulation. Defaults to \code{FALSE}}

\item{method}{default currently set to 'bayesGAMfit'.}

\item{...}{Arguments passed to \code{rstan::sampling} (e.g. iter, chains).}
}
\value{
An object of class \code{bayesGAMfit}.  Includes slots:



\code{results}:  \code{stanfit} object returned by \code{rstan::sampling}

\code{model}:  \code{glmModel} object

\code{offset}:  offset vector from the input parameter

\code{spcontrol}:  list of control parameters from input
}
\description{
Based on \code{\link[stats:glm]{glm}}.  \code{bayesGAM} is used to fit a variety of statistical models, including linear models, generalized lienar models, mixed effect models with random intercept, and semiparametric regression models.
}
\details{
Similar to \code{glm}, models are typically specified by formula.
The formula typically takes the form \code{response ~ terms}, where the response is numeric
and terms specify the linear predictor for the response.  The terms may be numeric variables or factors.

The link function for the Generalized Linear Model is specified with a \code{\link[stats:family]{family}} object.
Currently, this package supports gaussian, binomial, and poisson families with all available link functions.

The list \code{spcontrol} currently supports additional parameters to facilitate fitting models.
\code{qr} is a logical indicator specifying whether the design matrix should be transformed via QR decomposition prior to HMC sampling.
QR decomposition often improves the efficiency with which HMC samples, as the MCMC chain navigates an orthogonal
space more easily than highly correlated parameters.
\code{mvindep} is a logical indicator for multivariate response models with random intercepts. This indicates whether
the multivariate responses should be considered independent. Defaults to \code{FALSE}
}
\examples{
## Dobson (1990) Page 93: Randomized Controlled Trial :
counts <- c(18,17,15,20,10,20,25,13,12)
outcome <- gl(3,1,9)
treatment <- gl(3,3)
fpois<- bayesGAM(counts ~ outcome + treatment, family = poisson(),
                 spcontrol = list(qr = TRUE))
summary(fpois)
}
\references{
Hastie, T. J. (1992) Generalized additive models. Chapter 7 of \emph{Statistical Models in S} eds J. M. Chambers and T. J. Hastie, Wadsworth & Brooks/Cole.

Dobson, A. J. (1990) \emph{An Introduction to Generalized Linear Models}. London: Chapman and Hall.
}
