% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllMethods.R
\name{fitted}
\alias{fitted}
\alias{fitted,bayesGAMfit-method}
\title{Extract fitted values from a model fit by \code{bayesGAM}}
\usage{
\S4method{fitted}{bayesGAMfit}(object, ...)
}
\arguments{
\item{object}{an object of class \code{bayesGAMfit}, usually a result of a call to \code{bayesGAM}.}

\item{...}{additional arguments to pass to \code{coefficients}}
}
\value{
Numeric vector of fitted values
}
\description{
Method for \code{bayesGAMfit} objects.  Extracts the fitted values based on a specified quantile for the posterior distribution. The median is the default.
}
\examples{
require(stats); require(graphics)
f <- bayesGAM(weight ~ np(height), data = women, family = gaussian, 
              iter = 500, chains = 1)
plot(fitted(f), women$weight, type='o', xlab="fitted", ylab="actual")
}
