% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllMethods.R
\name{showPrior}
\alias{showPrior}
\alias{showPrior,bayesGAMfit-method}
\title{Display the priors used in \code{bayesGAM}}
\usage{
showPrior(object, ...)

\S4method{showPrior}{bayesGAMfit}(object, params = "all")
}
\arguments{
\item{object}{Object of type \code{bayesGAMfit} generated from \code{bayesGAM}}

\item{...}{Additional arguments for \code{showPrior}}

\item{params}{character vector of the names of parameters to return
\itemize{
\item \eqn{\beta} beta
\item \eqn{\epsilon} eps
\item \eqn{\lambda} lambda
\item \eqn{a] a}
}}
}
\value{
none
}
\description{
Prints a list of priors for \eqn{\beta}, \eqn{\lambda}, \eqn{\epsilon}, and \eqn{a}, where applicable.
}
\examples{
require(stats); require(graphics)
f <- bayesGAM(weight ~ np(height), data = women, 
              family = gaussian, iter = 500, chains = 1)
showPrior(f)
}
