% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/smcPotts.R
\name{initSedki}
\alias{initSedki}
\title{Initialize the ABC algorithm using the method of Sedki et al. (2013)}
\usage{
initSedki(y, neighbors, blocks, param = list(npart = 10000),
  priors = NULL)
}
\arguments{
\item{y}{A vector of observed pixel data.}

\item{neighbors}{A matrix of all neighbours in the lattice, one row per pixel.}

\item{blocks}{A list of pixel indices, dividing the lattice into independent blocks.}

\item{param}{A list of options for the ABC-SMC algorithm.}

\item{priors}{A list of priors for the parameters of the model.}
}
\value{
A matrix containing SMC samples for the parameters of the Potts model.
}
\description{
Initialize the ABC algorithm using the method of Sedki et al. (2013)
}
\references{
Sedki, M.; Pudlo, P.; Marin, J.-M.; Robert, C. P. & Cornuet, J.-M. (2013) "Efficient learning in ABC algorithms" \href{http://arxiv.org/abs/1210.1388}{arXiv:1210.1388}
}
