% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bmrm.R
\name{bmrm}
\alias{bmrm}
\title{Bayesian Analysis of Multivariate Receptor Modeling}
\usage{
bmrm(Y, q, muP,errdist="norm", df=4,
            varP.free=100, xi=NULL, Omega=NULL,
              a0=0.01, b0=0.01,
             nAdapt=1000, nBurnIn=5000, nIter=5000, nThin=1,
             P.init=NULL, A.init=NULL, Sigma.init=NULL,...)
}
\arguments{
\item{Y}{data matrix}

\item{q}{number of sources. It must be a positive integer.}

\item{muP}{(q,ncol(Y))-dimensional prior mean matrix for the source
composition matrix P, where q is the number of sources.
Zeros need to be assigned to prespecified elements of muP to satisfy
the identifiability condition C1. For the remaining free elements,
any nonnegative numbers (between 0 and 1 preferably) can be assigned.
If no or an insufficient number of zeros are preassigned in muP,
estimation can still be performed but the resulting estimates may
be subject to rotational ambiguities. (default=0.5 for nonzero elements ).}

\item{errdist}{error distribution: either "norm" for normal distribution or "t"
for t distribution (default="norm")}

\item{df}{degrees of freedom of a t-distribution when errdist="t" (default=4)}

\item{varP.free}{scalar value of the prior variance of the free (nonzero) elements
of the source composition matrix P (default=100)}

\item{xi}{prior mean vector of the q-dimensional source contribution
vector at time t  (default=vector of 1's)}

\item{Omega}{diagonal matrix of the prior variance of the q-dimensional
source contribution vector at time t (default=identity matrix)}

\item{a0}{shape parameter of the Inverse Gamma prior of the error variance
(default=0.01)}

\item{b0}{scale parameter of the Inverse Gamma prior of the error variance
(default=0.01)}

\item{nAdapt}{number of iterations for adaptation in 'JAGS' (default=1000)}

\item{nBurnIn}{number of iterations for the burn-in period in MCMC (default=5000)}

\item{nIter}{number of iterations for monitoring samples from MCMC
(default=5000). \code{nIter} samples are saved in each chain of MCMC.}

\item{nThin}{thinning interval for monitoring samples from MCMC (default=1)}

\item{P.init}{initial value of the source composition matrix P.
If omitted, zeros are assigned to the elements corresponding to
zero elements in muP  and the nonzero elements of P.init will be
 randomly generated from a uniform distrbution.}

\item{A.init}{initial value of the source contribution matrix A.
If omitted, it will be calculated from Y and P.init.}

\item{Sigma.init}{initial value of the error variance.
If omitted, it will be calculated from Y, A.init and P.init.}

\item{...}{arguments to be passed to methods}
}
\value{
in \code{bmrm} object
\describe{
  \item{nsource}{number of sources}
  \item{nobs}{number of observations in data Y}
  \item{nvar}{number of variables in data Y}
  \item{Y}{observed data matrix}
  \item{muP}{prior mean of the source composition matrix P}
  \item{errdist}{error distribution}
  \item{df}{degrees of freedom when errdist="t"}
  \item{A.hat}{posterior mean of the source contribution matrix A}
  \item{P.hat}{posterior mean of the source composition matrix P}
  \item{Sigma.hat}{posterior mean of the error variance Sigma}
  \item{A.sd}{posterior standard deviation of the source contribution matrix A}
  \item{P.sd}{posterior standard deviation of the source composition matrix P}
  \item{Sigma.sd}{posterior standard deviation of the error variance Sigma}
  \item{A.quantiles}{posterior quantlies of A for prob=(0.025, 0.05,
  0.25, 0.5, 0.75, 0.95, 0.975)}
  \item{P.quantiles}{posterior quantiles of P for prob=(0.025, 0.05,
  0.25, 0.5, 0.75, 0.95, 0.975)}
  \item{Sigma.quantiles}{posterior quantiles of Sigma for prob=(0.025, 0.05,
  0.25, 0.5, 0.75, 0.95, 0.975)}
  \item{Y.hat}{predicted value of Y computed from A.hat*P.hat}
  \item{residual}{Y-Y.hat}
  \item{codaSamples}{MCMC posterior samples of A, P, and \eqn{\Sigma} in class "mcmc.list"}
  \item{nIter}{number of MCMC iterations per chain for monitoring samples from
   MCMC}
  \item{nBurnIn}{number of iterations for the burn-in period in MCMC}
  \item{nThin}{thinning interval for monitoring samples from MCMC}
}
}
\description{
Generate posterior samples of the source
 composition matrix  P, the source contribution matrix A,
 and the error variance \eqn{\Sigma} using 'JAGS', and computes
 estimates of A,P,\eqn{\Sigma}.
}
\details{
\emph{Model}

The basic model for Bayesian multivariate receptor model is
  as follows:

       \eqn{Y_t=A_t P+E_t, t=1,\cdots,T},

  where
  \itemize{
    \item \eqn{Y_t} is a vector of observations of \eqn{J} variables at time
         \eqn{t}, \eqn{t = 1,\cdots,T}.
    \item \eqn{P} is a \eqn{q \times J}  source composition
            matrix in which the \eqn{k}-th row represents the \eqn{k}-th source
           composition profiles, \eqn{k=1,\cdots,q}, \eqn{q} is the number of sources.
    \item \eqn{A_t} is a \eqn{q} dimensional source contribution vector at time \eqn{t},
           \eqn{t=1,\cdots,T}.
    \item \eqn{E_t =(E_{t1}, \cdots, E_{tJ})} is an error term
          for the \eqn{t}-th observations,
          following \eqn{E_{t} \sim N(0, \Sigma)} or \eqn{E_{t} \sim t_{df}(0, \Sigma)},
         independently for \eqn{j = 1,\cdots,J}, where \eqn{\Sigma = diag(\sigma_{1}^2,...,
     \sigma_{J}^2)}.
 }

\emph{Priors}
 \itemize{
  \item Prior distribution of \eqn{A_t} is given as
  a truncated multivariate normal distribution,
       \itemize{
        \item \eqn{ A_t \sim N(\xi,\Omega) I(A_t \ge 0)}, independently for
       \eqn{t = 1,\cdots,T}.
       }
  \item Prior distribution of \eqn{P_{kj}} (the \eqn{(k,j)}-th element  of the source
  composition matrix \eqn{P}) is given as
      \itemize{
      \item
      \eqn{ P_{kj} \sim N(\code{muP}_{kj} , \code{varP.free} )I(P_{kj}
      \ge 0)}, for free (nonzero) \eqn{P_{kj}},
      \item
      \eqn{ P_{kj} \sim N(0, 1e-10 )I(P_{kj} \ge 0)}, for zero \eqn{P_{kj}},

      independently for  \eqn{k = 1,\cdots,q; j = 1,\cdots,J }.
      }
  \item Prior distribution of \eqn{\sigma_j^2} is \eqn{IG(a0, b0)}, i.e.,
     \itemize{
      \item \eqn{1/\sigma_j^2 \sim Gamma(a0, b0)}, having mean \eqn{a0/b0},
  independently for \eqn{j=1,...,J}.
     }
}

\emph{Notes}
  \itemize{
      \item
     We use the prior
     \eqn{ P_{kj} \sim N(0, 1e-10 )I(P_{kj} \ge 0)}  that is practically equal
     to the point mass at 0 to simplify the model building in 'JAGS'.
     \item  The MCMC samples of A and P are post-processed (rescaled) before saving
     so that \eqn{ \sum_{j=1}^J P_{kj} =1} for each \eqn{k=1,...,q} (the identifiablity
     condition C3 of Park and Oh (2015).
 }
}
\examples{
\donttest{
data(Elpaso); Y=Elpaso$Y ; muP=Elpaso$muP ; q=nrow(muP)
out.Elpaso <- bmrm(Y,q,muP)
summary(out.Elpaso)
plot(out.Elpaso)
}
}
\references{
Park, E.S. and Oh, M-S. (2015), Robust Bayesian Multivariate
 Receptor Modeling, Chemometrics and intelligent laboratory systems,
 149, 215-226.

Plummer, M. 2003. JAGS: A program for analysis of Bayesian
graphical models using Gibbs sampling. Proceedings of the 3rd
international workshop on distributed statistical computing, pp. 125.
 Technische Universit at Wien, Wien, Austria.

Plummer, M. 2015. 'JAGS' Version 4.0.0 user manual.
}
