% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AIC_bayesbr.R
\name{AIC_bayesbr}
\alias{AIC_bayesbr}
\title{Akaike Information Criterion}
\usage{
AIC_bayesbr(x)
}
\arguments{
\item{x}{an object of the class \emph{bayesbr}, containing the list returned from the \code{\link{bayesbr}} function.}
}
\value{
A number corresponding to the AIC (Akaike Information Criterion) of the estimated model.
}
\description{
A function that receives the estimated model data, uses the information from the loglik and the number of estimated parameters and returns the AIC, an estimator for the quality of the estimation of a model.
}
\details{
Proposed by Akaike (1974) the AIC (Akaike Information Criterion) measures the quality of the adjustment made by the model, when comparing adjusted models with the same data, the smaller the AIC the better the adjustment.

The AIC theory requires that the log-likelihood has been maximized, but as we are in the context of Bayesian statistics, the log-likelihood as explained in the \code{\link{logLik.bayesbr}} is made with the average of the a priori distribution for each theta and applying this value in the formula to calculate the loglik.
The AIC is calculated by
\deqn{AIC = 2 * k - 2 * L ,}
where \code{k} is the number of covariates used in the model, and \code{L} is the average of the loglik chain returned by the function \code{\link{logLik.bayesbr}}.
}
\examples{
data("CarTask",package = "bayesbr")

car_bayesbr <- bayesbr(probability ~ NFCCscale + task,
                      data = CarTask,iter =100)
aic = AIC_bayesbr(car_bayesbr)
}
\references{
\doi{10.1109/TAC.1974.1100705} Akaike, H. (1974). A new look at the statistical model identification. \emph{IEEE transactions on automatic control}, \bold{19}(6), 716-723.
}
\seealso{
\code{\link{logLik.bayesbr}},\code{\link{BIC_bayesbr}},\code{\link{DIC_bayesbr}}
}
