% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dfa_loadings.R
\name{dfa_loadings}
\alias{dfa_loadings}
\title{Get the loadings from a DFA as a data frame}
\usage{
dfa_loadings(rotated_modelfit, names = NULL, summary = TRUE, conf_level = 0.95)
}
\arguments{
\item{rotated_modelfit}{Output from \code{\link{rotate_trends}}.}

\item{names}{An optional vector of names for plotting the loadings.}

\item{summary}{Logical. Should the full posterior densities be returned? Defaults to \code{TRUE}.}

\item{conf_level}{Confidence level for credible intervals. Defaults to 0.95.}
}
\value{
A data frame with the following columns:
\code{name} is an identifier for each loading, \code{trend} is the trend for the
loading, \code{median} is the posterior median loading, \code{lower} is the lower CI,
\code{upper} is the upper CI, and \code{prob_diff0} is the probability the loading is
different than 0. When \code{summary = FALSE}, there is no \code{lower} or \code{upper}
columns and instead there are columns \code{chain} and \code{draw}.
}
\description{
Get the loadings from a DFA as a data frame
}
\examples{
set.seed(42)
s <- sim_dfa(num_trends = 2, num_ts = 4, num_years = 10)
# only 1 chain and 180 iterations used so example runs quickly:
m <- fit_dfa(y = s$y_sim, num_trends = 2, iter = 50, chains = 1)
r <- rotate_trends(m)
loadings <- dfa_loadings(r, summary = TRUE)
loadings <- dfa_loadings(r, summary = FALSE)
}
\seealso{
plot_loadings fit_dfa rotate_trends
}
