% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{mixedresponse_posterior_prediction}
\alias{mixedresponse_posterior_prediction}
\title{Posterior Predictions of Item Factor Analysis with Mixed Response Types}
\usage{
mixedresponse_posterior_prediction(
  OUTPUT,
  Y,
  Ms,
  variable_predict_flag,
  bounds,
  n_mcmc_iterations = 10L
)
}
\arguments{
\item{OUTPUT}{A list of output from IFA_Mode_Jumper_MixedResponses.}

\item{Y}{A N by J matrix of item responses for predictions. Variables to predict are indicated in Y by NAs.}

\item{Ms}{model indicator where 0 = "bounded", 1 = "continuous", 2 = "binary", >2 = "ordinal".}

\item{variable_predict_flag}{A J vector. 0 = do not predict the variable; 1 = predict the variable.}

\item{bounds}{A J by 2 matrix denoting the min and max variable values. Note that bounds are only used for variable j if element j of Ms is zero.}

\item{n_mcmc_iterations}{The number of Gibbs iterations for sampling posterior predictions for factor scores and missing data. The default is 10 iterations.}
}
\value{
array of predictions for all posterior samples provided in OUTPUT.
}
\description{
Generate posterior predictions for new variables using posterior samples.
}
\author{
Steven Andrew Culpepper
}
