% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prior.R
\name{get_prior}
\alias{get_prior}
\title{Get the prior distribution of a model parameter}
\usage{
get_prior(model,par,lag = 0)
}
\arguments{
\item{model}{a time series model class specified in varstan.}

\item{par}{a string value with the  desired parameter which a prior is defined could be:
"mu0", "sigma0", "ar", "ma", "arch", "garch", "mgarch", "dfv", "df", "LKJ" or "breg".}

\item{lag}{an optional integer value, indicates the desired lag of the parameter which the prior
is defined if lag = 0, then the prior distribution will be applied for all lags}
}
\value{
None. Prints the prior distribution of a desired parameter.
}
\description{
The functions gets the defined distribution of a defined model parameter
}
\examples{
library(astsa)
# get all the ar parameters
dat = Sarima(birth,order = c(2,1,2))
get_prior(model = dat,par = "ar")

# change the mean constant parameter
dat = set_prior(model = dat,par = "mu0",dist = student(0,2.5,7))
get_prior(dat,par = "mu0")

# change and print only the second ma parameter
dat = set_prior(model = dat,par = "ma",dist = beta(2,2),lag = 2)
get_prior(dat,par = "ma")

}
\author{
Asael Alonzo Matamoros
}
