% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ssm.R
\name{ssm}
\alias{ssm}
\title{A  constructor for a Additive linear State space model.}
\usage{
ssm(ts,trend = FALSE,damped = FALSE,seasonal = FALSE,xreg = NULL,
           period = 0,genT = FALSE,series.name = NULL)
}
\arguments{
\item{ts}{a numeric or ts object with the univariate time series.}

\item{trend}{a boolean value to specify a trend local level model. By default
is \code{FALSE}.}

\item{damped}{a boolean value to specify a damped trend local level model. By default
is \code{FALSE}. If \code{trend} option is \code{FALSE} then \code{damped} is set to
\code{FALSE} automatically.}

\item{seasonal}{a boolean value to specify a seasonal local level model. By default
is \code{FALSE}.}

\item{xreg}{Optionally, a numerical matrix of external regressors,
which must have the same number of rows as ts. It should not be a data frame.}

\item{period}{an integer specifying the periodicity of the time series by
default the value frequency(ts) is used.}

\item{genT}{a boolean value to specify for a generalized t-student SSM model.}

\item{series.name}{an optional string vector with the time series names.}
}
\value{
The function returns a list with the data for running \code{stan()} function of
\pkg{rstan} package.
}
\description{
Constructor of the \code{ets("Z","Z","Z")} object for Bayesian estimation in \pkg{Stan}.
}
\details{
The function returns a list with the data for running \code{stan()} function of
\pkg{rstan} package.

By  default  the  \code{ssm()}  function generates a local level model (or a ets("A","N","N") or
exponential smoothing model from the \pkg{forecast} package). If \code{trend} is set \code{TRUE},
then  a  local  trend ssm model is defined (a equivalent ets("A","A","N") or Holt model from the
\pkg{forecast} package). For damped trend models set \code{damped} to \code{TRUE}. If \code{seasonal}
is  set  to  \code{TRUE} a seasonal local level model is defined (a equivalent ets("A","N","A") model
from  the  \pkg{forecast} package). For a Holt-Winters method (ets("A","A","A")) set \code{Trend} and
\code{seasonal} to \code{TRUE}.

When \code{genT} option is \code{TRUE} a t-student innovations ssm model (see Ardia (2010)) is generated
see Fonseca, et. al (2019) for more details.

The default priors used in a ssm( ) model are:

\itemize{
\item{level ~ normal(0,0.5)}
\item{Trend ~ normal(0,0.5)}
\item{damped~ normal(0,0.5)}
\item{Seasonal ~ normal(0,0.5)}
\item{sigma0 ~ t-student(0,1,7)}
\item{level1 ~ normal(0,1)}
\item{trend1 ~ normal(0,1)}
\item{seasonal1 ~ normal(0,1)}
\item{dfv ~ gamma(2,0.1)}
\item{breg ~ t-student(0,2.5,6)}
}

For changing the default prior use the function \code{set_prior()}.
}
\examples{
mod1 = ssm(ipc)

# Declaring a Holt model for the ipc data.
mod2 = ssm(ipc,trend = TRUE,damped = TRUE)

# Declaring an additive Holt-Winters model for the birth data
mod3 = ssm(birth,trend = TRUE,damped = TRUE,seasonal = TRUE)

}
\references{
Fonseca, T. and Cequeira, V. and Migon, H. and Torres, C. (2019). The effects of
degrees of freedom estimation in the Asymmetric GARCH model with Student-t
Innovations. \emph{arXiv} \code{doi: arXiv: 1910.01398}.
}
\seealso{
\code{\link{Sarima}} \code{\link{auto.arima}} \code{\link{set_prior}} \code{\link{garch}}
}
\author{
Asael Alonzo Matamoros.
}
