% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict.lm_b.R
\name{predict.lm_b}
\alias{predict.lm_b}
\title{Predict method for lm_b model fits}
\usage{
\method{predict}{lm_b}(object, newdata, CI_level = 0.95, PI_level = 0.95, n_draws = 0, ...)
}
\arguments{
\item{object}{Object of class lm_b}

\item{newdata}{An optional data.frame in which to look for variables with which
to predict.}

\item{CI_level}{Posterior probability covered by credible interval}

\item{PI_level}{Posterior probability covered by prediction interval}

\item{n_draws}{If desired, the number of posterior samples drawn.}

\item{...}{optional arguments.}
}
\value{
tibble with estimate (posterior mean), prediction intervals, and credible intervals
for the mean.
}
\description{
Predict method for lm_b model fits
}
\examples{
\donttest{
set.seed(2025)
N = 500
test_data <-
  data.frame(x1 = rnorm(N),
             x2 = rnorm(N),
             x3 = letters[1:5])
test_data$outcome <-
  rnorm(N,-1 + test_data$x1 + 2 * (test_data$x3 \%in\% c("d","e")) )
fit1 <-
  lm_b(outcome ~ x1 + x2 + x3,
       data = test_data)
predict(fit1)
}

}
