% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/parsnip-adaptive_spline.R
\name{adaptive_spline}
\alias{adaptive_spline}
\title{General Interface for Adaptive Spline Surface Models}
\usage{
adaptive_spline(
  mode = "regression",
  splines_degree = NULL,
  max_degree = NULL,
  max_categorical_degree = NULL,
  min_basis_points = NULL
)
}
\arguments{
\item{mode}{A single character string for the type of model.
The only possible value for this model is "regression".}

\item{splines_degree}{degree of splines. Stability should be examined for anything other than 1.}

\item{max_degree}{integer for maximum degree of interaction in spline basis functions.
Defaults to the number of predictors, which could result in overfitting.}

\item{max_categorical_degree}{(categorical input only) integer for maximum degree of interaction of categorical inputs.}

\item{min_basis_points}{minimum number of non-zero points in a basis function. If the response is functional, this refers only to the portion of the basis function coming from the non-functional predictors.
Defaults to 20 or 0.1 times the number of observations, whichever is smaller.}
}
\value{
A model spec
}
\description{
\code{adaptive_spline()} is a way to generate a \emph{specification} of an Adaptive Spline Surface model
before fitting and allows the model to be created using
different packages. Currently the only package is \code{BASS}.
}
\details{
The data given to the function are not saved and are only used
to determine the \emph{mode} of the model. For \code{adaptive_spline()}, the
mode will always be "regression".

The model can be created using the \code{fit()} function using the
following \emph{engines}:
\itemize{
\item "stan" (default) - Connects to \code{\link[BASS:bass]{BASS::bass()}}
}

\strong{Main Arguments}

The main arguments (tuning parameters) for the model are:
\itemize{
\item \code{splines_degree}
\item \code{max_degree}
\item \code{max_categorical_degree}
\item \code{min_basis_points}
}

These arguments are converted to their specific names at the
time that the model is fit.

Other options and argument can be
set using \code{set_engine()} (See Engine Details below).

If parameters need to be modified, \code{update()} can be used
in lieu of recreating the object from scratch.
}
\section{Engine Details}{


Other options can be set using \code{set_engine()}.

\strong{stan (default engine)}

The engine uses \code{\link[BASS:bass]{BASS::bass()}}.

Parameter Notes:
\itemize{
\item \code{xreg} - This is supplied via the parsnip / bayesmodels \code{fit()} interface
(so don't provide this manually). See Fit Details (below).
}
}

\section{Fit Details}{


\strong{Date and Date-Time Variable}

It's a requirement to have a date or date-time variable as a predictor.
The \code{fit()} interface accepts date and date-time features and handles them internally.
\itemize{
\item \code{fit(y ~ date)}
}

\strong{Univariate (No xregs, Exogenous Regressors):}

This algorithm only accepts multivariate: you need to pass xregs (read next section).

\strong{Multivariate (xregs, Exogenous Regressors)}

The \code{xreg} parameter is populated using the \code{fit()} function:
\itemize{
\item Only \code{factor}, \verb{ordered factor}, and \code{numeric} data will be used as xregs.
\item Date and Date-time variables are not used as xregs
\item \code{character} data should be converted to factor.
}

\emph{Xreg Example:} Suppose you have 3 features:
\enumerate{
\item \code{y} (target)
\item \code{date} (time stamp),
\item \code{month.lbl} (labeled month as a ordered factor).
}

The \code{month.lbl} is an exogenous regressor that can be passed to the \code{sarima_reg()} using
\code{fit()}:
\itemize{
\item \code{fit(y ~ date + month.lbl)} will pass \code{month.lbl} on as an exogenous regressor.
}

Note that date or date-time class values are excluded from \code{xreg}.
}

\examples{
\dontrun{
#The example works, just building problem
library(dplyr)
library(parsnip)
library(rsample)
library(timetk)
library(modeltime)
library(bayesmodels)
library(lubridate)

# Data
m750 <- m4_monthly \%>\% filter(id == "M750")
m750

# Split Data 80/20
splits <- rsample::initial_time_split(m750, prop = 0.8)

# ---- Adaptive Spline ----

# Model Spec
model_spec <- adaptive_spline() \%>\%
    set_engine("stan")

# Fit Spec
model_fit <- model_spec \%>\%
    fit(log(value) ~ date + month(date), data = training(splits))
model_fit
}
}
\seealso{
\code{\link[=fit.model_spec]{fit.model_spec()}}, \code{\link[=set_engine]{set_engine()}}
}
