% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/segmentation_helper_functions.R
\name{find_breaks}
\alias{find_breaks}
\title{Find changes for integer variable}
\usage{
find_breaks(dat, ind)
}
\arguments{
\item{dat}{A data frame containing the data for each animal ID.}

\item{ind}{character. The name of the column storing the discrete variable of
interest.}
}
\value{
A vector of breakpoints is returned based on the data provided. If
  wishing to identify separate breakpoints per animal ID, this function
  should be mapped onto a list generated by \code{\link{df_to_list}}.
}
\description{
Identify changes within a discrete variable. These values can be used to
pre-specify breakpoints within the segmentation model using
\code{\link{segment_behavior}}.
}
\examples{
#simuluate data
var<- sample(1:3, size = 50, replace = TRUE)
var<- rep(var, each = 20)
id<- rep(1:10, each = 100)

#create data frame
dat<- data.frame(id, var)

#create list
dat.list<- df_to_list(dat = dat, ind = "id")

#run function using purrr::map()
breaks<- purrr::map(dat.list, ~find_breaks(dat = ., ind = "var"))

#or with lapply()
breaks1<- lapply(dat.list, find_breaks, ind = "var")

}
