% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_normal_normal.R
\name{plot_normal_normal}
\alias{plot_normal_normal}
\title{Plot a Normal-Normal Bayesian model}
\usage{
plot_normal_normal(
  mean,
  sd,
  sigma = NULL,
  y_bar = NULL,
  n = NULL,
  prior = TRUE,
  likelihood = TRUE,
  posterior = TRUE
)
}
\arguments{
\item{mean}{mean of the Normal prior}

\item{sd}{standard deviation of the Normal prior}

\item{sigma}{standard deviation of the data, or likelihood standard deviation}

\item{y_bar}{sample mean of the data}

\item{n}{sample size of the data}

\item{prior}{a logical value indicating whether the prior model should be plotted}

\item{likelihood}{a logical value indicating whether the scaled likelihood should be plotted}

\item{posterior}{a logical value indicating whether posterior model should be plotted}
}
\value{
a ggplot
}
\description{
Consider a Normal-Normal Bayesian model for mean parameter \eqn{\mu} with 
a N(mean, sd^2) prior on \eqn{\mu} and a Normal likelihood for the data. 
Given information on the prior (mean and sd) 
and data (the sample size n, mean y_bar, and standard deviation sigma),
this function produces a plot of any combination of the corresponding prior pdf, 
scaled likelihood function, and posterior pdf.  All three are included by default.
}
\examples{
plot_normal_normal(mean = 0, sd = 3, sigma= 4, y_bar = 5, n = 3)
plot_normal_normal(mean = 0, sd = 3, sigma= 4, y_bar = 5, n = 3, posterior = FALSE)
}
