% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulate_prior.R
\name{simulate_prior}
\alias{simulate_prior}
\title{Returns Priors of a Model as Empirical Distributions}
\usage{
simulate_prior(model, n = 1000, ...)
}
\arguments{
\item{model}{A \code{stanreg}, \code{stanfit}, or \code{brmsfit} object.}

\item{n}{Size of the simulated prior distributions.}

\item{...}{Currently not used.}
}
\description{
Transforms priors information to actual distributions.
}
\examples{
library(bayestestR)
library(rstanarm)

model <- stan_glm(mpg ~ wt + am, data = mtcars, chains = 1, refresh = 0)
simulate_prior(model)
}
