#' baymedr: Computation of Bayes Factors for Common Biomedical Designs
#'
#' \code{baymedr} provides functions for the computation of Bayes factors for
#' common biomedical research designs. At this point in time, functions for
#' equivalence, non-inferiority, and superiority designs are implemented.
#'
#' \tabular{ll}{ Package: \tab baymedr \cr Type: \tab Package \cr Version: \tab
#' 0.1.0 \cr License: \tab GPL-3 \cr Date: \tab 2019-10-17 \cr}
#'
#' At this point in time, \code{baymedr} entails tests for the following
#' research designs: \itemize{ \item Equivalence: \code{\link{equiv_bf}} \item
#' Non-Inferiority: \code{\link{infer_bf}} \item Superiority:
#' \code{\link{super_bf}} }
#'
#' @docType package
#' @name baymedr-package
#' @aliases baymedr-package baymedr
#' @author \strong{Maintainer}: Maximilian Linde --
#'   \email{maximilian.linde.92@@gmail.com}
#'
#'   Authors: \itemize{ \item Maximilian Linde (aut, cre) \item Don van
#'   Ravenzwaaij (aut) \item Quentin F. Gronau (ctb) }
#' @seealso Useful links: \itemize{ \item
#'   \url{https://github.com/maxlinde/baymedr} \item Report bugs at
#'   \url{https://github.com/maxlinde/baymedr/issues}}
NULL
