% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bayou-custommodel-input.R
\name{makeBayouModel}
\alias{makeBayouModel}
\title{This function makes a bayou model object that can be used for customized allometric regression models.}
\usage{
makeBayouModel(f, rjpars, tree, dat, pred, prior, SE = 0,
  slopechange = "immediate", impute = NULL, startpar = NULL,
  moves = NULL, control.weights = NULL, D = NULL, shiftpars = c("sb",
  "loc", "t2"), model = "OU")
}
\arguments{
\item{f}{A formula describing the relationship between the data and one or more predictors (use 'dat' 
for the dependent variable)}

\item{rjpars}{A character vector of parameters to split at the mapped shifts on the tree}

\item{tree}{A phylogenetic tree}

\item{dat}{A named vector of trait data (dependent variable)}

\item{pred}{A matrix or data frame with named columns with predictor data represented in the specified
formula}

\item{prior}{A prior function made by the 'make.prior' function}

\item{SE}{A single value or vector of measurement error estimates}

\item{slopechange}{"immediate", "alphaWeighted" or "fullPGLS"}

\item{impute}{The name of a single predictor for which missing values will be imputed using BM (see details).
Default is NULL.}

\item{startpar}{An optional list of starting parameters for the model. If not provided, the model will simulate
starting values from the prior function.}

\item{moves}{An optional list of moves to be passed on to bayou.makeMCMC.}

\item{control.weights}{An optional list of control weights to be passed on to bayou.makeMCMC.}

\item{D}{A vector of tuning parameters to be passed on to bayou.makeMCMC.}

\item{shiftpars}{The names of the parameters defining the map of shifts (for now, always c("sb", "loc", "t2")).}

\item{model}{The parameterization of the OU model, either "OU", "OUrepar" or "QG".}
}
\description{
This function makes a bayou model object that can be used for customized allometric regression models.
}
\details{
This function generates a list with the '$model', which provides the specifications of the regression
model and '$startpar', which provides starting values to input into bayou.makeMCMC. Note that this model assumes
that predictors immediately affect trait values at a shift. In other words, regardless of the past history of the
predictor, only the current value affects the current expected trait value. This is only reasonable for allometric
models, although it may be appropriate for other models if phylogenetic inertia is very low (short half-lives). 

One predictor variable may include missing data (coded as "NA"). The model will assume the maximum-likelihood
best-fit BM model and simulate the missing predictor values throughout the course of the MCMC. These values will
then be used to calculate the likelihood given the parameters for each MCMC step.
}
