% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/OptimizerIrace.R
\name{mlr_optimizers_irace}
\alias{mlr_optimizers_irace}
\alias{OptimizerIrace}
\title{Optimization via Iterated Racing}
\source{
Lopez-Ibanez M, Dubois-Lacoste J, Caceres LP, Birattari M, Stuetzle T (2016).
\dQuote{The irace package: Iterated racing for automatic algorithm configuration.}
\emph{Operations Research Perspectives}, \bold{3}, 43--58.
\doi{https://doi.org/10.1016/j.orp.2016.09.002}.
}
\description{
\code{OptimizerIrace} class that implements iterated racing. Calls
\code{\link[irace:irace]{irace::irace()}} from package \CRANpkg{irace}.
}
\section{Parameters}{

\describe{
\item{\code{instances}}{\code{list()}\cr
A list of instances where the configurations executed on.}
\item{\code{targetRunnerParallel}}{\verb{function()}\cr
A function that executes the objective function with a specific parameter
configuration and instance. A default function is provided, see section
"Target Runner and Instances".}
}

For the meaning of all other parameters, see \code{\link[irace:defaultScenario]{irace::defaultScenario()}}. Note
that we have removed all control parameters which refer to the termination of
the algorithm. Use \link{TerminatorEvals} instead. Other terminators do not work
with \code{OptimizerIrace}.
}

\section{Target Runner and Instances}{

The irace package uses a \code{targetRunner} script or R function to evaluate a
configuration on a particular instance. Usually it is not necessary to
specify a \code{targetRunner} function when using \code{OptimizerIrace}. A default
function is used that forwards several configurations and instances to the
user defined objective function. As usually, the user defined function has
a \code{xs}, \code{xss} or \code{xdt} parameter depending on the used \link{Objective} class.
For irace, the function needs an additional \code{instances} parameter.\preformatted{fun = function(xs, instances) \{
 # function to evaluate configuration in `xs` on instance `instances`
\}
}
}

\section{Archive}{

The \link{Archive} holds the following additional columns:
\itemize{
\item \code{"race"} (\code{integer(1)})\cr
Race iteration.
\item \code{"step"} (\code{integer(1)})\cr
Step number of race.
\item \code{"instance"} (\code{integer(1)})\cr
Identifies instances across races and steps.
\item \code{"configuration"} (\code{integer(1)})\cr
Identifies configurations across races and steps.
}
}

\section{Result}{

The optimization result (\code{instance$result}) is the best performing elite of
the final race. The reported performance is the average performance estimated
on all used instances.
}

\section{Dictionary}{

This \link{Optimizer} can be instantiated via the \link[mlr3misc:Dictionary]{dictionary}
\link{mlr_optimizers} or with the associated sugar function \code{\link[=opt]{opt()}}:\preformatted{mlr_optimizers$get("irace")
opt("irace")
}
}

\section{Progress Bars}{

\verb{$optimize()} supports progress bars via the package \CRANpkg{progressr}
combined with a \link{Terminator}. Simply wrap the function in
\code{progressr::with_progress()} to enable them. We recommend to use package
\CRANpkg{progress} as backend; enable with \code{progressr::handlers("progress")}.
}

\examples{
library(data.table)

search_space = domain = ps(
  x1 = p_dbl(-5, 10),
  x2 = p_dbl(0, 15)
)

codomain = ps(y = p_dbl(tags = "minimize"))

# branin function with noise
# the noise generates different instances of the branin function
# the noise values are passed via the `instances` parameter
fun = function(xdt, instances) {
  a = 1
  b = 5.1 / (4 * (pi^2))
  c = 5 / pi
  r = 6
  s = 10
  t = 1 / (8 * pi)

  data.table(y = (
    a * ((xdt[["x2"]] -
      b * (xdt[["x1"]]^2L) +
      c * xdt[["x1"]] - r)^2) +
      ((s * (1 - t)) * cos(xdt[["x1"]])) +
      unlist(instances)))
}

objective = ObjectiveRFunDt$new(fun = fun, domain = domain, codomain = codomain)

instance = OptimInstanceSingleCrit$new(
  objective = objective,
  search_space = search_space,
  terminator = trm("evals", n_evals = 1000))

# create instances of branin function
instances = rnorm(10, mean = 0, sd = 0.1)

# load optimizer irace and set branin instances
optimizer = opt("irace", instances = instances)

# modifies the instance by reference
optimizer$optimize(instance)

# best scoring configuration
instance$result

# all evaluations
as.data.table(instance$archive)
}
\section{Super class}{
\code{\link[bbotk:Optimizer]{bbotk::Optimizer}} -> \code{OptimizerIrace}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-new}{\code{OptimizerIrace$new()}}
\item \href{#method-clone}{\code{OptimizerIrace$clone()}}
}
}
\if{html}{
\out{<details open ><summary>Inherited methods</summary>}
\itemize{
\item \out{<span class="pkg-link" data-pkg="bbotk" data-topic="Optimizer" data-id="format">}\href{../../bbotk/html/Optimizer.html#method-format}{\code{bbotk::Optimizer$format()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="bbotk" data-topic="Optimizer" data-id="optimize">}\href{../../bbotk/html/Optimizer.html#method-optimize}{\code{bbotk::Optimizer$optimize()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="bbotk" data-topic="Optimizer" data-id="print">}\href{../../bbotk/html/Optimizer.html#method-print}{\code{bbotk::Optimizer$print()}}\out{</span>}
}
\out{</details>}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-new"></a>}}
\if{latex}{\out{\hypertarget{method-new}{}}}
\subsection{Method \code{new()}}{
Creates a new instance of this \link[R6:R6Class]{R6} class.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{OptimizerIrace$new()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-clone"></a>}}
\if{latex}{\out{\hypertarget{method-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{OptimizerIrace$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
