% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/OptimInstanceAsyncMultiCrit.R
\name{OptimInstanceAsyncMultiCrit}
\alias{OptimInstanceAsyncMultiCrit}
\title{Multi Criteria Optimization Instance for Asynchronous Optimization}
\description{
The \link{OptimInstanceAsyncMultiCrit} specifies an optimization problem for an \link{OptimizerAsync}.
The function \code{\link[=oi_async]{oi_async()}} creates an \link{OptimInstanceAsyncMultiCrit}.
}
\section{Super classes}{
\code{\link[bbotk:OptimInstance]{bbotk::OptimInstance}} -> \code{\link[bbotk:OptimInstanceAsync]{bbotk::OptimInstanceAsync}} -> \code{OptimInstanceAsyncMultiCrit}
}
\section{Active bindings}{
\if{html}{\out{<div class="r6-active-bindings">}}
\describe{
\item{\code{result_x_domain}}{(\code{list()})\cr
(transformed) x part of the result in the \emph{domain space} of the objective.}

\item{\code{result_y}}{(\code{numeric(1)})\cr
Optimal outcome.}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-OptimInstanceAsyncMultiCrit-new}{\code{OptimInstanceAsyncMultiCrit$new()}}
\item \href{#method-OptimInstanceAsyncMultiCrit-assign_result}{\code{OptimInstanceAsyncMultiCrit$assign_result()}}
\item \href{#method-OptimInstanceAsyncMultiCrit-clone}{\code{OptimInstanceAsyncMultiCrit$clone()}}
}
}
\if{html}{\out{
<details open><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="bbotk" data-topic="OptimInstance" data-id="format"><a href='../../bbotk/html/OptimInstance.html#method-OptimInstance-format'><code>bbotk::OptimInstance$format()</code></a></span></li>
<li><span class="pkg-link" data-pkg="bbotk" data-topic="OptimInstanceAsync" data-id="clear"><a href='../../bbotk/html/OptimInstanceAsync.html#method-OptimInstanceAsync-clear'><code>bbotk::OptimInstanceAsync$clear()</code></a></span></li>
<li><span class="pkg-link" data-pkg="bbotk" data-topic="OptimInstanceAsync" data-id="print"><a href='../../bbotk/html/OptimInstanceAsync.html#method-OptimInstanceAsync-print'><code>bbotk::OptimInstanceAsync$print()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-OptimInstanceAsyncMultiCrit-new"></a>}}
\if{latex}{\out{\hypertarget{method-OptimInstanceAsyncMultiCrit-new}{}}}
\subsection{Method \code{new()}}{
Creates a new instance of this \link[R6:R6Class]{R6} class.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{OptimInstanceAsyncMultiCrit$new(
  objective,
  search_space = NULL,
  terminator,
  check_values = FALSE,
  callbacks = NULL,
  archive = NULL,
  rush = NULL
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{objective}}{(\link{Objective})\cr
Objective function.}

\item{\code{search_space}}{(\link[paradox:ParamSet]{paradox::ParamSet})\cr
Specifies the search space for the \link{Optimizer}. The \link[paradox:ParamSet]{paradox::ParamSet}
describes either a subset of the \code{domain} of the \link{Objective} or it describes
a set of parameters together with a \code{trafo} function that transforms values
from the search space to values of the domain. Depending on the context, this
value defaults to the domain of the objective.}

\item{\code{terminator}}{\link{Terminator}\cr
Termination criterion.}

\item{\code{check_values}}{(\code{logical(1)})\cr
Should points before the evaluation and the results be checked for validity?}

\item{\code{callbacks}}{(list of \link[mlr3misc:Callback]{mlr3misc::Callback})\cr
List of callbacks.}

\item{\code{archive}}{(\link{Archive}).}

\item{\code{rush}}{(\code{Rush})\cr
If a rush instance is supplied, the tuning runs without batches.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-OptimInstanceAsyncMultiCrit-assign_result"></a>}}
\if{latex}{\out{\hypertarget{method-OptimInstanceAsyncMultiCrit-assign_result}{}}}
\subsection{Method \code{assign_result()}}{
The \link{OptimizerAsync} writes the best found points and estimated performance values here (probably the Pareto set / front).
For internal use.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{OptimInstanceAsyncMultiCrit$assign_result(xdt, ydt)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{xdt}}{(\code{\link[data.table:data.table]{data.table::data.table()}})\cr
Set of untransformed points / points from the \emph{search space}.
One point per row, e.g. \code{data.table(x1 = c(1, 3), x2 = c(2, 4))}.
Column names have to match ids of the \code{search_space}.
However, \code{xdt} can contain additional columns.}

\item{\code{ydt}}{(\code{numeric(1)})\cr
Optimal outcomes, e.g. the Pareto front.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-OptimInstanceAsyncMultiCrit-clone"></a>}}
\if{latex}{\out{\hypertarget{method-OptimInstanceAsyncMultiCrit-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{OptimInstanceAsyncMultiCrit$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
