% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Gaussian_Inference.r
\name{sufficientStatistics.GaussianNIG}
\alias{sufficientStatistics.GaussianNIG}
\title{Sufficient statistics of a "GaussianNIG" object}
\usage{
\method{sufficientStatistics}{GaussianNIG}(obj, x, X, foreach = FALSE, ...)
}
\arguments{
\item{obj}{A "GaussianNIG" object.}

\item{x}{numeric, must satisfy length(x) = nrow(X)}

\item{X}{matrix, must satisfy length(x) = nrow(X)}

\item{foreach}{logical, if foreach=TRUE, will return a list of sufficient statistics for each (x,X), otherwise will return the sufficient statistics as a whole.}

\item{...}{Additional arguments to be passed to other inherited types.}
}
\value{
If foreach=TRUE, will return a list of sufficient statistics for each row of (x,X), otherwise will return the sufficient statistics of (x,X) as a whole.
}
\description{
For following Gaussian-NIG model structure: \cr
     beta,sigma^2|gamma ~ NIG(gamma) \cr
     x|beta,sigma^2,X ~ Gaussian(X%*%beta,sigma^2) \cr
where gamma = (m,V,a,b) is the Normal-Inverse-Gamma(NIG) parameter, "m" is a numeric "location" parameter; "V" is a symmetric positive definite matrix representing the "scale" parameters; "a" and "b" are the "shape" and "rate" parameter of the Inverse Gamma distribution. \cr
The model structure and prior parameters are stored in a "GaussianNIG" object. \cr
The sufficient statistics of a set of samples (x,X) are: \cr
 the effective number of samples N=nrow(X) or length(x); \cr
 the covariance of X and x SXx=t(X)%*%x \cr
 the covariance of X SX=t(X)%*%X \cr
 the covariance of x Sx=t(x)%*%x
}
\examples{
obj <- GaussianNIG(gamma=list(m=0,V=1,a=1,b=0))
X <- 1:20
x <- rnorm(20)+ X*0.3
sufficientStatistics(obj = obj,X=X,x=x)
sufficientStatistics(obj = obj,X=X,x=x,foreach = TRUE)
}
\references{
Banerjee, Sudipto. "Bayesian Linear Model: Gory Details." Dowloaded from http://www. biostat. umn. edu/~ ph7440 (2008).
}
\seealso{
\code{\link{GaussianNIG}}, \code{\link{sufficientStatistics_Weighted.GaussianNIG}}
}
