% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Dirichlet_Process.r
\name{rPosteriorPredictive.DP}
\alias{rPosteriorPredictive.DP}
\title{Generate random samples from the posterior predictive distribution of a "DP" object}
\usage{
\method{rPosteriorPredictive}{DP}(obj, n = 1, x, ...)
}
\arguments{
\item{obj}{A "DP" object.}

\item{n}{integer, number of samples.}

\item{x}{Random samples of the "BasicBayesian" object.}

\item{...}{Additional arguments to be passed to other inherited types.}
}
\value{
integer, the categorical samples.
}
\description{
Generate random samples from the posterior predictive distribution of the following structure:
     \deqn{pi|alpha ~ DP(alpha,U)}
     \deqn{z|pi ~ Categorical(pi)}
     \deqn{theta_z|psi ~ H0(psi)}
     \deqn{x|theta_z,z ~ F(theta_z)}
where DP(alpha,U) is a Dirichlet Process on positive integers, alpha is the "concentration parameter" of the Dirichlet Process, U is the "base measure" of this Dirichlet process. The choice of F() and H0() can be described by an arbitrary "BasicBayesian" object such as "GaussianGaussian","GaussianInvWishart","GaussianNIW", "GaussianNIG", "CatDirichlet", and "CatDP". See \code{?BasicBayesian} for definition of "BasicBayesian" objects, and see for example \code{?GaussianGaussian} for specific "BasicBayesian" instances. As a summary, An "DP" object is simply a combination of a "CatDP" object (see \code{?CatDP}) and an object of any "BasicBayesian" type.\cr
The model structure and prior parameters are stored in a "DP" object. \cr
This function will generate random samples from the distribution  z|alpha,psi,x.
}
\examples{
x <- rnorm(4)
z <- sample(1L:10L,size = 4,replace = TRUE)
obj <- DP()
ss <- sufficientStatistics(obj = obj,x=x,foreach = TRUE)
for(i in 1L:length(x)) posterior(obj = obj,ss=ss[[i]],z=z[i])
xnew <- rnorm(10)
znew <- sample(1L:10L,size = 10,replace = TRUE)
rPosteriorPredictive(obj = obj,n=1,x=xnew[5])
}
\references{
Teh, Yee W., et al. "Sharing clusters among related groups: Hierarchical Dirichlet processes." Advances in neural information processing systems. 2005.
}
\seealso{
\code{\link{DP}}, \code{\link{dPosteriorPredictive.DP}}
}
