% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/preDisease.R
\name{preDATA}
\alias{preDATA}
\title{Preparing monotone ordered disease classes}
\usage{
preDATA(D, T, plot = TRUE)
}
\arguments{
\item{D}{a numeric vector/factor containing the disease status.}

\item{T}{a numeric vector containing the diagnostic test values. \code{NA} values are not admitted.}

\item{plot}{if TRUE (the default) then a boxplot of diagnostic test T based on three ordered groups is produced.}
}
\value{
This function returns a list containting a factor \code{D} of ordered disease status and a binary matrix \code{Dvec} of the disease status and a vector \code{order} containing the sequence of class labels.
}
\description{
\code{preDATA} is used to check and make a suitable monotone increasing ordering of the disease classes. In addition, this function also creates a binary matrix format of disease status to pass into the functions of \code{bcROCsurface} package.
}
\details{
The ROC surface analysis implemented in the package is coherent when the ordering of the diagnostic classes is monotone increasing. That is, for a diagnostic test \eqn{T} and three disease classes, 1, 2 and 3, the monotone increasing ordering of interest is \eqn{T_1 < T_2 < T_3}. Here, \eqn{T_1}, \eqn{T_2} and \eqn{T_3} are the measurements of diagnostic test \eqn{T} corresponding to class 1, 2 and 3, respectively. Note that, if an umbrella or tree ordering is of interest, then the results of ROC surface analysis is not reliable.

In order to find out the monotone ordering, we compute the medians of \eqn{T_1}, \eqn{T_2} and \eqn{T_3}, and then sort the three medians in ascending order. After that, the three disease classes are reordered corresponding to the order of medians.

To be used in the functions of package \code{bcROCsurface}, the vector of disease status must be presented as a n * 3 binary matrix with the three columns, corresponding to the three classes.

With real data, the application of this function is the first step in the use of ROC analysis. Note that, if the user is sure that the disease classes follow a monotone increasing ordering and the disease matrix is available, then the use of \code{preDATA} is not necessary.
}
\examples{
data(EOC)
Dfull <- preDATA(EOC$D.full, EOC$CA125)


}

