% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/bcp.R
\name{makeAdjGrid}
\alias{makeAdjGrid}
\title{Creating the adjacency structure for grid graphs}
\usage{
makeAdjGrid(n, m = NULL, k = 8)
}
\arguments{
\item{n}{the number of rows of vertices in the graph data.}

\item{m}{(optional) the number of column of vertices in the graph data. If not given, we assume \code{m = n}.}

\item{k}{(optional) the number of neighbors assumed for a typical vertex (see details below), either 4 or 8. Default number of neighbors is assumed to be 8.}
}
\description{
\code{makeAdjGrid()} produces a sparse representation of the adjacency structure for grid graphs, useful as the \code{adj} argument in \code{bcp()}.
}
\details{
\code{makeAdjGrid()} produces a list representation of the adjacency structure for grid graphs. The \eqn{i}-th entry in the list gives a vector of neighbor ids for the \eqn{i}-th node. Note that neighbor ids are offset by 1 because indexing starts at 0 in C++.
If \code{k = 8}, then we assume each node is joined via edges to its 8 neighbors in the (top left, top middle, top right, left, right, bottom left, bottom middle, and bottom right) directions, where applicable. If \code{k = 4}, then we assume each node is joined via edges to its 4 neighbors in the (top, right, bottom, left) directions, where applicable.
}
\examples{
# generates an adjacency list for a 10 node by 5 node grid, assuming a maximum of 8 neighbors
adj <- makeAdjGrid(10, 5)

# generates an adjacency list for a 10 node by 5 node grid, assuming a maximum of 4 neighbors
adj4 <- makeAdjGrid(10, 5, 4)


### show a grid example
\dontrun{
set.seed(5)
adj <- makeAdjGrid(20)
z <- rep(c(0, 2), each=200)
y <- z + rnorm(400, sd=1)
out <- bcp(y, adj=adj, burnin=500, mcmc=500)

if (require("ggplot2")) {
  df <- data.frame(mean=z, data = y, post.means = out$posterior.mean[,1],
                   post.probs = out$posterior.prob,
                   i = rep(1:20, each=20), j = rep(1:20, times=20))

  # visualize the data
  g <- ggplot(df, aes(i,j)) +
         geom_tile(aes(fill = data), color='white') +
         scale_fill_gradientn(limits=range(y), colours=c('white', 'steelblue'))+
         ggtitle("Observed Data")
  print(g)

  # visualize the means
  g <- ggplot(df, aes(i,j)) +
         geom_tile(aes(fill = mean), color='white') +
         scale_fill_gradientn(limits=range(y), colours=c('white', 'steelblue'))+
         ggtitle("True Means")
  print(g)

  # visualize the posterior means/probs
  g <- ggplot(df, aes(i,j)) +
         geom_tile(aes(fill = post.means), color='white') +
         scale_fill_gradientn(limits=range(y), colours=c('white', 'steelblue'))+
         ggtitle("Posterior Means")
  print(g)

  g <- ggplot(df, aes(i,j)) +
         geom_tile(aes(fill = post.probs), color='white') +
         scale_fill_gradientn(limits=c(0, 1), colours=c('white', 'steelblue'))+
         ggtitle("Posterior Boundary Probabilities")
  print(g)
}
}
}
\author{
Xiaofei Wang
}
\seealso{
\code{\link{bcp}} for performing Bayesian change point analysis.
}
\keyword{datasets}

