% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AbbreviationPipe.R
\docType{class}
\name{AbbreviationPipe}
\alias{AbbreviationPipe}
\title{Class to find and/or replace the abbreviations on the data field of an Instance}
\usage{
AbbreviationPipe
}
\description{
\code{\link{AbbreviationPipe}} class is responsible for detecting
the existing abbreviations in the \strong{data} field of each \code{\link{Instance}}.
Identified abbreviations are stored inside the \strong{abbreviation} field of
\code{\link{Instance}} class. Moreover if needed, is able to perform inline
abbreviations replacement.
}
\section{Constructor}{

\preformatted{
AbbreviationPipe$new(propertyName = "abbreviation",
                     propertyLanguageName = "language",
                     alwaysBeforeDeps = list("GuessLanguagePipe"),
                     notAfterDeps = list(),
                     replaceAbbreviations = TRUE,
                     resourcesAbbreviationsPath = NULL)
}
\itemize{
\item{\emph{Arguments:}}{
\itemize{
\item{\strong{propertyName:}}{
(\emph{character}) name of the property associated with the Pipe.
}
\item{\strong{propertyLanguageName:}}{
(\emph{character}) name of the language property.
}
\item{\strong{alwaysBeforeDeps:}}{
(\emph{list}) the dependences alwaysBefore (Pipes that must be executed before this
one).
}
\item{\strong{notAfterDeps:}}{
(\emph{list}) the dependences notAfter (Pipes that cannot be executed after this one).
}
\item{\strong{replaceAbbreviations:}}{
(\emph{logical}) indicates if the abbreviations are replaced or not.
}
\item{\strong{resourcesAbbreviationsPath:}}{
(\emph{character}) path of resource files (in json format) containing the
correspondence between abbreviations and meaning.
}
}
}
}
}

\section{Details}{

\code{\link{AbbreviationPipe}} class requires the resource files (in json format)
containing the correspondence between abbreviations and meaning. To this end,
the language of the text indicated in the \emph{propertyLanguageName} should
be contained in the resource file name (ie. abbrev.xxx.json where xxx is the
value defined in the \emph{propertyLanguageName} ). The location of the
resources should be defined in the \strong{"resources.abbreviations.path"}
field of \emph{\link{bdpar.Options}} variable.
}

\section{Note}{

\code{\link{AbbreviationPipe}} will automatically invalidate the
\code{\link{Instance}} whenever the obtained data is empty.
}

\section{Inherit}{

This class inherits from \code{\link{GenericPipe}} and implements the
\code{pipe} abstract function.
}

\section{Methods}{

\itemize{
\item{\bold{pipe:}}{
preprocesses the \code{\link{Instance}} to obtain/replace the abbreviations.
The abbreviations found in the Pipe are added to the list of properties of
the \code{\link{Instance}}.
\itemize{
\item{\emph{Usage:}}{
\code{pipe(instance)}
}
\item{\emph{Value:}}{
the \code{\link{Instance}} with the modifications that have occurred in the pipe.
}
\item{\emph{Arguments:}}{
\itemize{
\item{\strong{instance:}}{
(\emph{Instance}) \code{\link{Instance}} to preproccess.
}
}
}
}
}

\item{\bold{findAbbreviation:}}{
checks if the abbreviation is in the data.
\itemize{
\item{\emph{Usage:}}{
\code{findAbbreviation(data, abbreviation)}
}
\item{\emph{Value:}}{
boolean, depending on whether the abbreviation is in the data.
}
\item{\emph{Arguments:}}{
\itemize{
\item{\strong{data:}}{
(\emph{character}) text where abbreviation will be searched.
}
\item{\strong{abbreviation:}}{
(\emph{character}) indicates the abbreviation to find.
}
}
}
}
}

\item{\bold{replaceAbbreviation:}}{
replaces the abbreviation in the data for the extendedAbbreviation.
\itemize{
\item{\emph{Usage:}}{
\code{replaceAbbreviation(abbreviation, extendedAbbreviation, data)}
}
\item{\emph{Value:}}{
the data with the abbreviatons replaced.
}
\item{\emph{Arguments:}}{
\itemize{
\item{\strong{abbreviation:}}{
(\emph{character}) indicates the abbreviation to replace.
}
\item{\strong{extendedAbbreviation:}}{
(\emph{character}) indicates the string to replace for the abbreviations found.
}
\item{\strong{data:}}{
(\emph{character}) text where abbreviation will be replaced.
}
}
}
}
}

\item{\bold{getPropertyLanguageName:}}{
gets of name of property language.
\itemize{
\item{\emph{Usage:}}{
\code{getPropertyLanguageName()}
}
\item{\emph{Value:}}{
value of name of property language.
}
}
}

\item{\bold{getResourcesAbbreviationsPath:}}{
gets of path of abbreviations resources.
\itemize{
\item{\emph{Usage:}}{
\code{getResourcesAbbreviationsPath()}
}
\item{\emph{Value:}}{
value of path of abbreviations resources.
}
}
}

\item{\bold{setResourcesAbbreviationsPath:}}{
sets the path of abbreviations resources.
\itemize{
\item{\emph{Usage:}}{
\code{setResourcesAbbreviationsPath(path)}
}
\item{\emph{Arguments:}}{
\itemize{
\item{\strong{path:}}{
(\emph{character}) the new value of the path of abbreviations resources.
}
}
}
}
}
}
}

\section{Private fields}{

\itemize{
\item{\bold{propertyLanguageName:}}{
 (\emph{character}) the name of property about language.
}
\item{\bold{resourcesAbbreviationsPath:}}{
 (\emph{character}) path of resource files (in json format) containing the
correspondence between abbreviations and meaning.
}
\item{\bold{replaceAbbreviations:}}{
 (\emph{logical}) indicates if the abbreviations are replaced or not.
}
}
}

\seealso{
\code{\link{bdpar.Options}}, \code{\link{ContractionPipe}},
         \code{\link{File2Pipe}}, \code{\link{FindEmojiPipe}},
         \code{\link{FindEmoticonPipe}}, \code{\link{FindHashtagPipe}},
         \code{\link{FindUrlPipe}}, \code{\link{FindUserNamePipe}},
         \code{\link{GuessDatePipe}}, \code{\link{GuessLanguagePipe}},
         \code{\link{Instance}}, \code{\link{InterjectionPipe}},
         \code{\link{MeasureLengthPipe}}, \code{\link{GenericPipe}},
         \code{\link{ResourceHandler}}, \code{\link{SlangPipe}},
         \code{\link{StopWordPipe}}, \code{\link{StoreFileExtPipe}},
         \code{\link{TargetAssigningPipe}}, \code{\link{TeeCSVPipe}},
         \code{\link{ToLowerCasePipe}}
}
