% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ResourceHandler.R
\docType{class}
\name{ResourceHandler}
\alias{ResourceHandler}
\title{Class that handles different types of resources}
\usage{
ResourceHandler
}
\description{
Class that handles different types of resources.
}
\section{Constructor}{

\code{ResourceHandler$new()}
}

\section{Details}{

It is a class that allows store the resources that are needed
in the Pipes to avoid having to repeatedly read from the file. File resources
of type json are read and stored in memory.
}

\section{Methods}{

\itemize{
\item{\bold{isLoadResource:}}{
from the resource path, it is checked if they have already been loaded. In
this case, the list of the requested resource is returned. Otherwise, the
resource variable is added to the list of resources, and the resource list is
returned. In the event that the resource file does not exist, NULL is returned.
\itemize{
\item{\emph{Usage:}}{
\code{isLoadResource(pathResource)}
}
\item{\emph{Arguments:}}{
\itemize{
\item{\strong{pathResource:}}{
(\emph{character}) resource file path.
}
}
}
}
}

\item{\bold{getResources:}}{
gets of resources variable.
\itemize{
\item{\emph{Usage:}}{
\code{getResources()}
}
\item{\emph{Value:}}{
value of resources variable.
}
}
}

\item{\bold{setResources:}}{
sets of resources.
\itemize{
\item{\emph{Usage:}}{
\code{setResources(resources)}
}
\item{\emph{Arguments:}}{
\itemize{
\item{\strong{resources:}}{
(\emph{list}) the new value of resources.
}
}
}
}
}

\item{\bold{getNamesResources:}}{
gets of names of resources.
\itemize{
\item{\emph{Usage:}}{
\code{getNamesResources()}
}
\item{\emph{Value:}}{
value of names of resources.
}
}
}
}
}

\section{Private fields}{

\itemize{
\item{\bold{resources:}}{
 (\emph{list}) variable that stores the lists of the different types of resources.
}
}
}

