% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TeeCSVPipe.R
\docType{class}
\name{TeeCSVPipe}
\alias{TeeCSVPipe}
\title{Class to handle a CSV with the properties field of the preprocessed Instance}
\usage{
TeeCSVPipe
}
\description{
Complete a CSV with the properties of the preprocessed \code{\link{Instance}}.
}
\section{Constructor}{

\preformatted{
TeeCSVPipe$new(propertyName = "",
               alwaysBeforeDeps = list(),
               notAfterDeps = list(),
               withData = TRUE,
               withSource = TRUE)
}
\itemize{
\item{\emph{Arguments}}{
\itemize{
\item{\strong{propertyName:}}{
(\emph{character}) name of the property associated with the Pipe.
}
\item{\strong{alwaysBeforeDeps:}}{
(\emph{list}) the dependences alwaysBefore (Pipes that must be executed before this
one).
}
\item{\strong{notAfterDeps:}}{
(\emph{list}) the dependences notAfter (Pipes that cannot be executed after this one).
}
\item{\strong{withData:}}{
(\emph{logical}) indicates if the data is added to CSV.
}
\item{\strong{withSource:}}{
(\emph{logical}) indicates if the source is added to CSV.
}
}
}
}
}

\section{Details}{

The path to save the properties should be defined in the
\strong{"teeCSVPipe.output.path"} field of
\emph{\link{bdpar.Options}} variable.
}

\section{Inherit}{

This class inherits from \code{\link{GenericPipe}} and implements the
\code{pipe} abstract function.
}

\section{Methods}{

\itemize{
\item{\bold{pipe:}}{
completes the CSV with the preprocessed \code{\link{Instance}}.
\itemize{
\item{\emph{Usage:}}{
\code{pipe(instance)}
}
\item{\emph{Value:}}{
the \code{\link{Instance}} with the modifications that have occurred in the Pipe.
}
\item{\emph{Arguments:}}{
\itemize{
\item{\strong{instance:}}{
(\emph{Instance}) \code{\link{Instance}} to preproccess.
}
}
}
}
}
}
}

\section{Private fields}{

\itemize{
\item{\bold{withSource:}}{
 (\emph{logical}) indicates if the source is added to CSV.
}
\item{\bold{withData:}}{
 (\emph{logical}) indicates if the data is added to CSV.
}
}
}

\seealso{
\code{\link{AbbreviationPipe}}, \code{\link{bdpar.Options}},
         \code{\link{ContractionPipe}}, \code{\link{File2Pipe}},
         \code{\link{FindEmojiPipe}}, \code{\link{FindEmoticonPipe}},
         \code{\link{FindHashtagPipe}}, \code{\link{FindUrlPipe}},
         \code{\link{FindUserNamePipe}}, \code{\link{GuessDatePipe}},
         \code{\link{GuessLanguagePipe}}, \code{\link{Instance}},
         \code{\link{InterjectionPipe}}, \code{\link{MeasureLengthPipe}},
         \code{\link{GenericPipe}}, \code{\link{ResourceHandler}},
         \code{\link{SlangPipe}}, \code{\link{StopWordPipe}},
         \code{\link{StoreFileExtPipe}}, \code{\link{TargetAssigningPipe}},
         \code{\link{ToLowerCasePipe}}
}
