% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Bdpar.R
\name{Bdpar}
\alias{Bdpar}
\title{Class to manage the preprocess of the files throughout the flow of pipes}
\description{
\code{\link{Bdpar}} class provides the static variables required
to perform the whole data flow process. To this end \code{\link{Bdpar}} is
in charge of (i) initialize the objects of handle the connections to APIs
(\code{\link{Connections}}) and handles json resources (\code{\link{ResourceHandler}})
and (ii) executing the flow of pipes (inherited from \code{\link{GenericPipeline}} class)
passed as argument.
}
\section{Details}{

In the case that some pipe, defined on the workflow, needs some type of
configuration, it can be defined through \emph{\link{bdpar.Options}} variable
which have different methods to support the functionality of different pipes.
}

\section{Static variables}{

\itemize{
\item{\bold{connections}:}{
(\emph{Connections}) object that handles the connections with YouTube and
Twitter.
}
\item{\bold{resourceHandler}:}{
(\emph{ResourceHandler}) object that handles the json resources files.
}
}
}

\examples{
\dontrun{

#If it is necessary to indicate any configuration, do it through:
#bdpar.Options$set(key, value)
#If the key is not initialized, do it through:
#bdpar.Options$add(key, value)

#If it is necessary parallelize, do it through:
#bdpar.Options$set("numCores", numCores)

#If it is necessary to change the behavior of the log, do it through:
#bdpar.Options$configureLog(console = TRUE, threshold = "INFO", file = NULL)

#Folder with the files to preprocess
path <- system.file("example",
                    package = "bdpar")

#Object which decides how creates the instances
extractors <- ExtractorFactory$new()

#Object which indicates the pipes' flow
pipeline <- DefaultPipeline$new()

objectBdpar <- Bdpar$new()

#Starting file preprocessing...
objectBdpar$execute(path = path,
                    extractors = extractors,
                    pipeline = pipeline,
                    cache = FALSE,
                    verbose = FALSE,
                    summary = TRUE)
}
}
\seealso{
\code{\link{bdpar.Options}}, \code{\link{Connections}},
         \code{\link{DefaultPipeline}}, \code{\link{DynamicPipeline}},
         \code{\link{GenericPipeline}}, \code{\link{Instance}},
         \code{\link{ExtractorFactory}}, \code{\link{ResourceHandler}},
         \code{\link{runPipeline}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-new}{\code{Bdpar$new()}}
\item \href{#method-execute}{\code{Bdpar$execute()}}
\item \href{#method-clone}{\code{Bdpar$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-new"></a>}}
\if{latex}{\out{\hypertarget{method-new}{}}}
\subsection{Method \code{new()}}{
Creates a \link{Bdpar} object. Initializes the static
variables: \emph{connections} and \emph{resourceHandler}.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Bdpar$new()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-execute"></a>}}
\if{latex}{\out{\hypertarget{method-execute}{}}}
\subsection{Method \code{execute()}}{
Preprocess files through the indicated flow of pipes.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Bdpar$execute(
  path,
  extractors = ExtractorFactory$new(),
  pipeline = DefaultPipeline$new(),
  cache = TRUE,
  verbose = FALSE,
  summary = FALSE
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{path}}{A \code{\link{character}} value. The path where the files to
be processed are located.}

\item{\code{extractors}}{A \code{\link{ExtractorFactory}} value. Class which
implements the \code{createInstance} method to choose which type of
\code{\link{Instance}} is created.}

\item{\code{pipeline}}{A \code{\link{GenericPipeline}} value. Subclass of
\code{\link{GenericPipeline}}, which implements the \code{execute} method.
By default, it is the \code{\link{DefaultPipeline}} pipeline.}

\item{\code{cache}}{(\emph{logical}) flag indicating if the status of the instances
will be stored after each pipe. This allows to avoid rejections of previously
executed tasks, if the order and configuration of the pipe and pipeline is
the same as what is stored in the cache.}

\item{\code{verbose}}{(\emph{logical}) flag indicating for printing messages, warnings and errors.}

\item{\code{summary}}{(\emph{logical}) flag indicating if a summary of the
pipeline execution is provided or not.}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
In case of wanting to parallelize, it is necessary to indicate
the number of cores to be used through bdpar.Options$set("numCores", numCores)
}

\subsection{Returns}{
The list of \code{Instances} that have been preprocessed.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-clone"></a>}}
\if{latex}{\out{\hypertarget{method-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Bdpar$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
