#' Creates the \code{init} section of a BEAST2 XML parameter file
#' @inheritParams default_params_doc
#' @return lines of XML text
#' @author Richèl J.C. Bilderbeek
#' @export
create_beast2_input_init <- function(
  inference_model,
  id = "deprecated",
  ids = "deprecated"
) {
  if (id != "deprecated") {
    stop("'id' is deprecated, use 'inference_model' instead")
  }
  if (ids != "deprecated") {
    stop("'ids' is deprecated, use 'inference_model' instead")
  }
  # Do not be smart yet
  ids <- inference_model$site_model$id
  testit::assert(length(ids) == 1)
  testit::assert(beautier::are_ids(ids))

  text <- NULL

  # From https://www.beast2.org/fix-starting-tree/:
  #
  # if there is an initaliser generated by BEAUti of the form
  #
  #   <init estimate="false" id="RandomTree.t:xxx" initial="@Tree.t:xxx"
  #     spec="beast.evolution.tree.RandomTree" taxa="@xxx">
  #   </init>
  #
  # remove this element from the file, otherwise the tree will be Newick tree
  #   will be overwritten by a random tree.
  #
  # In other words: bluntly remove it
  n <- length(ids)
  for (i in seq(1, n)) {
    id <- ids[i]
    text <- c(text, "")
    text <- c(
      text,
      beautier::indent(beautier::rnd_phylo_to_xml_init(inference_model))
    )
  }
  text
}
