% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create_tree_prior.R
\name{create_cbs_tree_prior}
\alias{create_cbs_tree_prior}
\alias{create_tree_prior_cbs}
\title{Create a Coalescent Bayesian Skyline tree prior}
\usage{
create_cbs_tree_prior(id = NA, group_sizes_dimension = 5)
}
\arguments{
\item{id}{an alignment's IDs.
An ID can be extracted from its FASTA filename
with \code{\link{get_alignment_ids_from_fasta_filenames}})}

\item{group_sizes_dimension}{the group sizes' dimension,
as used by the CBS tree prior (see \code{\link{create_cbs_tree_prior}})}
}
\value{
a Coalescent Bayesian Skyline tree_prior
}
\description{
Create a Coalescent Bayesian Skyline tree prior
}
\examples{
  cbs_tree_prior <- create_cbs_tree_prior()

  beast2_input_file <- tempfile(fileext = ".xml")
  create_beast2_input_file(
    input_filename = get_beautier_path("test_output_6.fas"),
    beast2_input_file,
    tree_prior = cbs_tree_prior
  )
  testit::assert(file.exists(beast2_input_file))
}
\seealso{
An alignment ID can be extracted from
  its FASTA filename using \code{\link{get_alignment_id}}
}
\author{
Richèl J.C. Bilderbeek
}
