% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create_distr.R
\name{create_exp_distr}
\alias{create_exp_distr}
\alias{create_distr_exp}
\title{Create an exponential distribution}
\usage{
create_exp_distr(id = NA, mean = 1, value = NA, lower = NA, upper = NA)
}
\arguments{
\item{id}{the distribution's ID}

\item{mean}{the mean parameter,
a numeric value.
For advanced usage, use the structure
as returned by \code{\link{create_mean_param}}}

\item{value}{the initial value for the MCMC}

\item{lower}{the lower bound, the lowest possible value}

\item{upper}{an upper limit of the uniform distribution.
If the upper limits needs to be infinity, set \code{upper} to \code{Inf}.}
}
\value{
an exponential distribution
}
\description{
Create an exponential distribution
}
\examples{
check_empty_beautier_folder()

exp_distr <- create_exp_distr()

beast2_input_file <- get_beautier_tempfilename()
create_beast2_input_file(
  input_filename = get_fasta_filename(),
  beast2_input_file,
  tree_prior = create_yule_tree_prior(
    birth_rate_distr = exp_distr
  )
)
file.remove(beast2_input_file)

remove_beautier_folder()
check_empty_beautier_folder()
}
\seealso{
the function \code{\link{create_distr}} shows an overview
  of all supported distributions
}
\author{
Richèl J.C. Bilderbeek
}
