% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/foo.R
\name{dfplot}
\alias{dfplot}
\title{Plot a dataframe, multiple ys against one x}
\usage{
dfplot(x, y, add = FALSE, xlab = "", ylab = "", myaxes = FALSE, xlim = NULL, 
    ylim = NULL, mycol = NULL, mytype = "l", mypch = 20, mycex = 1, mylty = NULL, 
    lwd = 1, xerror = NULL, yerror = NULL, mycolerrorbar = NULL, mylegend = NULL, 
    mylegendcol = mycol, mylegendcex = 1, legendpos = "top")
}
\arguments{
\item{x}{a vector}

\item{y}{a vector or a dataframe with the same length as x}

\item{add}{logical, whether to add this plot to the previous one}

\item{xlab}{character}

\item{ylab}{character}

\item{myaxes}{logical, whether to display axes automatically}

\item{xlim}{numeric}

\item{ylim}{numeric}

\item{mycol}{colours}

\item{mytype}{character}

\item{mypch}{numeric or character}

\item{mycex}{numeric}

\item{mylty}{numeric}

\item{lwd}{numeric}

\item{xerror}{errorbar, same dimension of x}

\item{yerror}{same dimension of y}

\item{mycolerrorbar}{error bar colours}

\item{mylegend}{character}

\item{mylegendcol}{colors}

\item{mylegendcex}{numeric}

\item{legendpos}{character}
}
\value{
a figure
}
\description{
Plot a dataframe, multiple ys against one x
}
\examples{
x <- seq(0, 2 * pi, length.out = 100)
y <- data.frame(sin(x), cos(x))
yerror <- data.frame(abs(rnorm(100, sd = 0.3)), abs(rnorm(100, sd = 0.1)))
dfplot(x, y, yerror = yerror)

}
