% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dMCD.R
\name{dMCD}
\alias{dMCD}
\title{Estimate Cohen's d corresponding to a Meaningful Change Definition}
\usage{
dMCD(cer, mcd = NULL, eer = NULL, plot = TRUE, mcdOnX = FALSE,
  plotResultValues = TRUE, resultValueLineColor = "blue",
  resultValueLineSize = 1, returnLineLayerOnly = FALSE,
  theme = ggplot2::theme_bw(), highestPossibleEER = 0.999999999,
  xLab = ifelse(mcdOnX, "Meaningful Change Definition",
  "Control Event Rate"), yLab = "Cohen's d", ...)
}
\arguments{
\item{cer}{The Control Event Rate (or base rate): how many people already
perform the target behavior in the population (as a proportion)?}

\item{mcd}{The Meaningful Change Definitions: by which percentage (as a
proportion) should the event rate increase to render an effect meaningful?}

\item{eer}{Instead of the MCD, it is also possible to specify the Experimental
Event Rate (EER), in which case the MCD is computed by taking the difference
with the CER.}

\item{plot}{Whether to show a plot.}

\item{mcdOnX}{Whether to plot the Meaningful Change Definition on the X axis
(by default, the CER is plotted on the X axis).}

\item{plotResultValues}{Whether to plot the result values.}

\item{resultValueLineColor, resultValueLineSize}{If plotting the result values,
lines of this color and size are used.}

\item{returnLineLayerOnly}{Whether to only return a layer with the plotted
line (which can be used to quickly stack lines for different MCDs).}

\item{theme}{The \code{ggplot2} theme to use.}

\item{highestPossibleEER}{The highest possible EER to include in the plot.}

\item{xLab, yLab}{The labels for the X and Y axes.}

\item{...}{Any additional arguments are passed on to the \code{ggplot2::geom_line}
used to draw the line showing the different Cohen's d values as a function of
the base rate (or MCD) on the X axis.}
}
\value{
The Cohen's d value, optionally with a \code{ggplot2} plot stored in an
attribute (which is only a \code{ggplot2} layer if \code{returnLineLayerOnly=TRUE}).
}
\description{
This function uses a base rate (Control Event Rate, argument \code{cer}) and a
Meaningful Change Definitions (MCD, argument \code{mcd}) to compute the
corresponding Cohen's d. See Gruijters & Peters (2019) for details.
}
\examples{
dMCD(.2, .05);
}
\references{
Gruijters, S. L. K., & Peters, G.-J. Y. (2019). Meaningful change
definitions: Sample size planning for experimental intervention research.
\emph{PsyArXiv}. \doi{10.31234/osf.io/jc295}
}
