% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aic.R
\name{AIC.zibellreg}
\alias{AIC.zibellreg}
\title{Akaike information criterion for zibellreg objects}
\usage{
\method{AIC}{zibellreg}(object, ..., k = 2)
}
\arguments{
\item{object}{an object of the class zibellreg.}

\item{...}{further arguments passed to or from other methods.}

\item{k}{numeric, the penalty per parameter to be used; the default k = 2 is the classical AIC.}
}
\value{
the Akaike information criterion value when a single model is passed to the function; otherwise, a data.frame with the Akaike information criterion values and the number of parameters is returned.
}
\description{
Akaike information criterion for zibellreg objects
}
\examples{
\donttest{
library(bellreg)
data(cells)
fit1 <- zibellreg(cells ~ 1|1, data = cells, approach = "mle")
fit2 <- zibellreg(cells ~ 1|smoker+gender, data = cells, approach = "mle")
fit3 <- zibellreg(cells ~ smoker+gender|smoker+gender, data = cells, approach = "mle")
AIC(fit1, fit2, fit3)
}

}
