% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/autoplot.R
\name{autoplot.bench_mark}
\alias{autoplot.bench_mark}
\alias{plot.bench_mark}
\title{Autoplot method for bench_mark objects}
\usage{
autoplot.bench_mark(object, type = c("beeswarm", "jitter", "ridge",
  "boxplot", "violin"), ...)

\method{plot}{bench_mark}(x, ..., type = c("beeswarm", "jitter", "ridge",
  "boxplot", "violin"), y)
}
\arguments{
\item{object}{A \code{bench_mark} object.}

\item{type}{The type of plot. Plotting geoms used for each type are
\itemize{
\item beeswarm - \code{\link[ggbeeswarm:geom_quasirandom]{ggbeeswarm::geom_quasirandom()}}
\item jitter - \code{\link[ggplot2:geom_jitter]{ggplot2::geom_jitter()}}
\item ridge - \code{\link[ggridges:geom_density_ridges]{ggridges::geom_density_ridges()}}
\item boxplot - \code{\link[ggplot2:geom_boxplot]{ggplot2::geom_boxplot()}}
\item violin - \code{\link[ggplot2:geom_violin]{ggplot2::geom_violin()}}
}}

\item{...}{Additional arguments passed to the plotting geom.}

\item{x}{A \code{bench_mark} object.}

\item{y}{Ignored, required for compatibility with the \code{plot()} generic.}
}
\description{
Autoplot method for bench_mark objects
}
\details{
This function requires some optional dependencies. \link[ggplot2:ggplot2-package]{ggplot2},
\link[tidyr:tidyr-package]{tidyr}, and depending on the plot type
\link[ggbeeswarm:ggbeeswarm]{ggbeeswarm}, \link[ggridges:ggridges]{ggridges}.

For \code{type} of \code{beeswarm} and \code{jitter} the points are colored by the highest
level garbage collection performed during each iteration.

For plots with 2 parameters \code{ggplot2::facet_grid()} is used to construct a
2d facet. For other numbers of parameters \code{ggplot2::facet_wrap()} is used
instead.
}
\examples{
dat <- data.frame(x = runif(10000, 1, 1000), y=runif(10000, 1, 1000))

res <- bench::mark(
  dat[dat$x > 500, ],
  dat[which(dat$x > 500), ],
  subset(dat, x > 500))

if (require(ggplot2)) {

  # Beeswarm plot
  autoplot(res)

  # ridge (joyplot)
  autoplot(res, "ridge")

  # If you want to have the plots ordered by execution time you can do so by
  # ordering factor levels in the expressions.
  if (require(dplyr) && require(forcats)) {

    res \%>\%
      mutate(expression = forcats::fct_reorder(as.character(expression), min, .desc = TRUE)) \%>\%
      as_bench_mark() \%>\%
      autoplot("violin")
  }
}
}
