% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/benchmark_programming.R, R/benchmarks.R
\name{bm_prog_fib}
\alias{bm_prog_fib}
\alias{bm_prog_hilbert}
\alias{bm_prog_gcd}
\alias{bm_prog_toeplitz}
\alias{bm_prog_escoufier}
\alias{benchmark_prog}
\title{Programming benchmarks}
\usage{
bm_prog_fib(runs = 3, verbose = TRUE)

bm_prog_hilbert(runs = 3, verbose = TRUE)

bm_prog_gcd(runs = 3, verbose = TRUE)

bm_prog_toeplitz(runs = 3, verbose = TRUE)

bm_prog_escoufier(runs = 3, verbose = TRUE)

benchmark_prog(runs = 3, verbose = TRUE, cores = 0L)
}
\arguments{
\item{runs}{Number of times to run the test. Default 3.}

\item{verbose}{Default TRUE.}

\item{cores}{Default 0 (serial). When cores > 0, the benchmark is run in parallel.}
}
\description{
A collection of matrix programming benchmark functions
\itemize{
\item 3,500,000 Fibonacci numbers calculation (vector calc).
\item Creation of a 3500x3500 Hilbert matrix (matrix calc).
\item Grand common divisors of 1,000,000 pairs (recursion).
\item Creation of a 1600x1600 Toeplitz matrix (loops).
\item Escoufier's method on a 60x60 matrix (mixed).
}
These benchmarks have been developed by many authors. 
See http://r.research.att.com/benchmarks/R-benchmark-25.R
for a complete history. The function \code{benchmark_prog()} runs the five \code{bm} functions.
}
