% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generate_model_data.R
\name{model_random_walk_data}
\alias{model_random_walk_data}
\title{generate model data for testing purposes}
\usage{
model_random_walk_data(
  N_t = 24,
  region_coeffs = c(5, 0.5),
  c_region = c(-1, 2),
  sigma = 2,
  zeta = 0.5,
  mu0 = -1,
  Orders = NULL,
  reporting_freq = NULL
)
}
\arguments{
\item{N_t}{number of time-points}

\item{region_coeffs}{vector of coefficients for regions determining kit orders}

\item{c_region}{logit probability of kit use per region}

\item{sigma}{standard deviation of error in logit probability of kit use}

\item{zeta}{standard deviation of random walk in logit space}

\item{mu0}{initial condition of random walk in logit space}

\item{Orders}{A 2D matrix of shape \code{length(region_coeffs)} by \code{N_t}}

\item{reporting_freq}{The frequency that distribution data is provided.
If \code{NULL} distribution frequency matches orders frequency}
}
\value{
A tibble
\describe{
\item{Orders}{Kit orders per time and region}
\item{regions}{Numeric index indicating region of orders and distributions}
\item{Reported_Used}{Number of kits reported as used}
\item{Reported_Distributed}{Number of kits reported as distributed}
\item{p_use}{Probability that a kit was used}
\item{p_reported}{Probability that a distributed kit was reported}
\item{times}{Index for time}
\item{region_name}{String index for the region}
}
}
\description{
Model generating process using random walk to match data generating model
in Bayesian framework
}
\seealso{
Other data generation: 
\code{\link{generate_model_data}()}
}
\concept{data generation}
