% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/traceCall.R
\name{traceCall}
\alias{traceCall}
\title{call stack of a function}
\usage{
traceCall(skip = 0, prefix = "\\nCall stack: ", suffix = "\\n")
}
\arguments{
\item{skip}{Number of levels to skip in \code{\link{traceback}}}

\item{prefix}{Prefix prepended to the output character string. DEFAULT: "\\nCall stack: "}

\item{suffix}{Suffix appended to the end of the output. DEFAULT: "\\n"}
}
\value{
Character string with the call stack
}
\description{
trace the call stack e.g. for error checking and format output for do.call levels
}
\section{Warning}{
 Called from \link{do.call} settings with large objects,
                  tracing may take a lot of computing time.
}
\examples{
lower <- function(a, s) {warning(traceCall(s), "stupid berry warning: ", a+10); a}
upper <- function(b, skip=0) lower(b+5, skip)
upper(3)
upper(3, skip=1) # traceCall skips last level (warning)
upper(3, skip=4) # now the stack is empty
upper(3, skip=-1) # get one more level down
d <- tryStack(upper("four"), silent=TRUE)
inherits(d, "try-error")
cat(d) 

}
\author{
Berry Boessenkool, \email{berry-b@gmx.de}, Sep 2016
}
\seealso{
\code{\link{tryStack}}, \code{\link{checkFile}} for example usage
}
\keyword{error}
\keyword{programming}

