% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/betafunctions.R
\name{binomialmoments}
\alias{binomialmoments}
\title{Compute Moments of Binomial Probability Mass Functions.}
\usage{
binomialmoments(n, p, types = c("raw", "central", "standardized"), orders = 4)
}
\arguments{
\item{n}{Number of Binomial trials}

\item{p}{Probability of success per trial.}

\item{types}{A character vector determining which moment-types are to be calculated. Permissible values are "raw", "central", and "standardized".}

\item{orders}{The number of moment-orders to be calculated for each of the moment-types.}
}
\value{
A list of moment types, each a list of moment orders.
}
\description{
Computes Raw, Central, or Standardized moment properties of defined Binomial probability mass functions.
}
\examples{
# Assume some variable follows a four-parameter Beta distribution with
# location parameters l = 0.25 and u = .75, and shape parameters a = 5
# and b = 3. To compute the first four raw, central, and standardized
# moments of this distrubution using betamoments():
betamoments(a = 5, b = 3, l = .25, u = .75,
types = c("raw", "central", "standardized"), orders = 4)
}
\references{
Hanson, B. A (1991). Method of Moments Estimates for the Four-Parameter Beta Compound Binomial Model and the Calculation of Classification Consistency Indexes. American College Testing Research Report Series.
}
