% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/betafunctions.R
\name{pGammaBinom}
\alias{pGammaBinom}
\title{Cumulative probability density function under the Gamma-extended Binomial distribution.}
\usage{
pGammaBinom(q, size, prob, lower.tail = TRUE)
}
\arguments{
\item{q}{Vector of quantiles.}

\item{size}{Number of "trials" (zero or more). Need not be integer.}

\item{prob}{Probability of "success" on each "trial". Need not be integer.}

\item{lower.tail}{Logical. If TRUE (default), probabilities are P[X<x], otherwise, P[X >= x]. Note that this differs from base-R \code{binom()} functions.}
}
\description{
Extends the cumulative Binomial probability mass function to positive non-integers, effectively turning the mass-function into a density-function.
}
\references{
Loeb, D. E. (1992). A generalization of the binomial coefficients. Discrete Mathematics, 105(1-3).
# Assume some variable follows a Gamma-Binomial  distribution with
# "number of trials" = 10.5 and probability of "success" for each "trial"
# = 0.75, to compute the cumulative probability to attain a "number of
success" below a specific point (e.g., less than 7.5 "successes":
pGammaBinom(q = 7.5, size = 10.5, prob = 0.75)

# Conversely, to attain a value at or above 7.5:
pGammaBinom(q = 7.5, size = 10.5, prob = 0.75, lower.tail = FALSE)
}
