% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/betafunctions.R
\name{betamode}
\alias{betamode}
\title{Compute Mode of Two- and Four-Parameter Beta Probability Density distribution.}
\usage{
betamode(alpha, beta, l = 0, u = 1)
}
\arguments{
\item{alpha}{The alpha shape parameter of the PDD.}

\item{beta}{The beta shape parameter of the PDD.}

\item{l}{The first (lower) location parameter of a four-parameter distribution. Default set to \code{0}.}

\item{u}{The second (upper) location parameter of a four-parameter distribution. Default set to \code{1}.}
}
\description{
Computes the mode of a Beta distribution with specified shape- and location parameters.
}
\examples{
# To calculate the mode of a two-parameter (standard) Beta distribution with
# shape parameters alpha = 5 and beta = 3:
betamode(alpha = 5, beta = 3)

# To calculate the mode of a four-parameter Beta distribution with shape
# parameters alpha = 5 and beta = 3, and location parameters l = 25 and
# u = 150:
betamode(alpha = 5, beta = 3, l = 25, u = 150)
}
