% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lm_betaselect_methods.R
\name{confint.lm_betaselect}
\alias{confint.lm_betaselect}
\alias{confint.glm_betaselect}
\title{Confidence Interval for
'lm_betaselect' or 'glm_betaselect'
Objects}
\usage{
\method{confint}{lm_betaselect}(
  object,
  parm,
  level = 0.95,
  method = c("boot", "bootstrap", "ls"),
  type = c("beta", "standardized", "raw", "unstandardized"),
  warn = TRUE,
  boot_type = c("perc", "bc"),
  ...
)

\method{confint}{glm_betaselect}(
  object,
  parm,
  level = 0.95,
  trace = FALSE,
  test = c("LRT", "Rao"),
  method = c("boot", "bootstrap", "default", "ls"),
  type = c("beta", "standardized", "raw", "unstandardized"),
  warn = TRUE,
  boot_type = c("perc", "bc"),
  transform_b = NULL,
  ...
)
}
\arguments{
\item{object}{The output of
\code{\link[=lm_betaselect]{lm_betaselect()}} or
\code{\link[=glm_betaselect]{glm_betaselect()}}.}

\item{parm}{The terms for which
the confidence intervals are returned.
If missing, the confidence intervals
of all terms will be returned.}

\item{level}{The level of confidence,
default is .95, returning the 95\%
confidence interval.}

\item{method}{The method used to
compute the confidence intervals/
If bootstrapping was
requested when calling
\code{\link[=lm_betaselect]{lm_betaselect()}} and this argument
is set to \code{"bootstrap"} or \code{"boot"},
the bootstrap confidence intervals
are returned. If bootstrapping
was not requested or if this argument
is set to \code{"ls"}, then the usual \code{lm}
confidence intervals are
returned, with a warning raised
unless \code{type} is \code{"raw"} or
\verb{"unstandardized".}
Default is \code{"boot"}.}

\item{type}{String. If
\code{"unstandardized"} or \code{"raw"}, the
confidence intervals of the
coefficients \emph{before} standardization
are returned. If \code{"beta"} or
\code{"standardized"}, then the
confidence intervals of the
coefficients \emph{after} selected
variables standardized are returned.
Default is \code{"beta"}.}

\item{warn}{Logical. Whether a warning
will be raised is OLS (or WLS)
confidence intervals are
requested for the model with some
variables standardized (i.e., \code{type}
is \code{"beta"} or \code{"standardized"}).
Default is \code{TRUE}.}

\item{boot_type}{The type of
bootstrap confidence intervals.
Currently, it supports \code{"perc"},
percentile bootstrap confidence
intervals, and \code{"bc"}, bias-corrected
bootstrap confidence interval.}

\item{...}{Optional arguments.
Ignored.}

\item{trace}{Logical. Whether profiling
will be traced. See
\code{\link[stats:confint]{stats::confint.glm()}} for details.
ignored if \code{method} is \code{"boot"} or
\code{"bootstrap"}.}

\item{test}{The test used for
profiling. See \link[stats:confint]{stats::confint.glm}
for details.
ignored if \code{method} is \code{"boot"} or
\code{"bootstrap"}.}

\item{transform_b}{The function
to be used to transform the
confidence limits. For example,
if set to \code{exp}, the confidence
limits will be exponentiated. Users
need to decide whether the transformed
limits are meaningful. Default is
\code{NULL}.}
}
\value{
A \emph{p} by 2 matrix of the confidence
intervals, \emph{p} being the number
of coefficients.
}
\description{
Return the confidence
interval of the regression
coefficients in the output of
\code{\link[=lm_betaselect]{lm_betaselect()}} or
\code{\link[=glm_betaselect]{glm_betaselect()}}.
}
\details{
The type of
confidence intervals depends
on the object. If bootstrapping
was requested, by default it returns
the percentile bootstrap confidence
intervals. Otherwise, it returns the
default confidence intervals.

Support for other type of
confidence intervals may be
added in the future.
}
\examples{

data(data_test_mod_cat)

# bootstrap should be set to 2000 or 5000 in real studies
lm_beta_x <- lm_betaselect(dv ~ iv*mod + cov1 + cat1,
                           data = data_test_mod_cat,
                           to_standardize = "iv",
                           do_boot = TRUE,
                           bootstrap = 100,
                           iseed = 1234)
confint(lm_beta_x)
confint(lm_beta_x, method = "ls")
confint(lm_beta_x, type = "raw")


data_test_mod_cat$p <- scale(data_test_mod_cat$dv)[, 1]
data_test_mod_cat$p <- ifelse(data_test_mod_cat$p > 0,
                              yes = 1,
                              no = 0)
# bootstrap should be set to 2000 or 5000 in real studies
logistic_beta_x <- glm_betaselect(p ~ iv*mod + cov1 + cat1,
                                  data = data_test_mod_cat,
                                  family = binomial,
                                  to_standardize = "iv",
                                  do_boot = TRUE,
                                  bootstrap = 100,
                                  iseed = 1234)

confint(logistic_beta_x, method = "default")
confint(logistic_beta_x, type = "raw")

}
\seealso{
\code{\link[=lm_betaselect]{lm_betaselect()}}
}
\author{
Shu Fai Cheung \url{https://orcid.org/0000-0002-9871-9448}
}
