% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/etry.R
\name{etry}
\alias{etry}
\alias{print.etry-error}
\title{Extended try}
\usage{
etry(
  expr,
  silent = FALSE,
  outFile = getOption("try.outFile", default = stderr()),
  max.lines = 100L,
  dump.frames = c("partial", "full", "full_global", "no")
)

\method{print}{`etry-error`}(
  x,
  max.lines = getOption("traceback.max.lines", getOption("deparse.max.lines", -1L)),
  ...
)
}
\arguments{
\item{expr}{an \R expression to try.}

\item{silent}{logical: should the report of error messages be
     suppressed?}

\item{outFile}{a \link[base]{connection}, or a character string naming the
    file to print to (via \code{\link[base]{cat}(*, file = outFile)});
    used only if \code{silent} is false, as by default.}

\item{max.lines}{for \code{etry}, the maximum number of lines to be
\emph{deparsed} per call. For \code{print}, the maximum number of lines to
be \emph{printed} per call. The default for the latter is unlimited.}

\item{dump.frames}{should a crash dump (cf. \code{\link[utils]{dump.frames}})
be created in case of an error? The default "partial" omits the frames up
to the call of \code{etry}. "full" and "no" do the obvious. "full_global"
additionally also includes (a copy of) the global environment (cf.
\code{include.GlobalEnv} argument of \code{\link[utils]{dump.frames}}).}

\item{x}{an object of class "etry-error".}

\item{...}{further arguments passed to or from other methods.}
}
\value{
For \code{etry}, the value of the expression if \code{expr} is
  evaluated without error, but an invisible object of class
  \code{c("etry-error", "try-error")} containing the error message if it
  fails. This object has three attributes: (condition) the error condition,
  (traceback) the traceback as returned by
  \code{\link[base:traceback]{.traceback}}, (dump.frames) the crash dump
  which can be examined using \code{\link[utils:debugger]{utils::debugger}}.
}
\description{
Extended version of \code{\link[base]{try}} with support for tracebacks and
crash dumps.
}
\section{Windows Support}{
 Fully supported on Windows.
}

\section{Lifecycle}{

  \ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#stable}{\figure{lifecycle-stable.svg}{options:
  alt='[Stable]'}}}{\strong{[Stable]}}
}

