\name{write.lpi}
\alias{write.lpi}
%- Also NEED an '\alias' for EACH other topic documented here.
\title{
Write linkage pattern information to file
}
\description{
Write function that outputs prior calculated linkage pattern information from a bipartite graph for a given vertex subset to a tab--separated file.
}
\usage{
\method{write}{lpi}(input, filename)
}
%- maybe also 'usage' for other objects documented here.
\arguments{
  \item{input}{
Object of class \verb{lpi}, e.g. generated by lpi() or by read.lpi(file,mode='lpi').
}
  \item{filename}{
name of file to write to.
}
}
\details{
%%  ~~ If necessary, more details than the description above ~~
}
\value{
}
\references{
Vogt, I. and Mestres, J. (in preparation) Assessing information loss associated with bipartite network projection.
}
\author{
Ingo Vogt <\email{bigraph.vogt@gmail.com}>
}
\note{
%%  ~~further notes~~
}

%% ~Make other sections like Warning with \section{Warning }{....} ~

\seealso{
\code{\link[biGraph]{lpi}}, \code{\link[biGraph]{read.lpi}}, \code{\link[biGraph]{summary.lpi}}, \code{\link[biGraph]{print.summary.lpi}}
}
\examples{
data(g)

## Extract linkage patterns
linkagePatterns <- lpi(g,vType=FALSE,mode='full')
linkagePatterns
summary(linkagePatterns)

## Write minimal linkage pattern information to file
linkagePatterns <- lpi(g,vType=FALSE,mode='minimal')
write.lpi(linkagePatterns, 'foomin.lpi')

## Read linkage patterns back to lpi object
linkagePatterns_b <- read.lpi('foomin.lpi')

## Read linkage patterns and construct graph from it
g_min <- (read.lpi('foomin.lpi'))$graph

## Compare original and reconstructed graph
def.par <- par(no.readonly = TRUE) # save default, for resetting...
par(mfrow=c(1,2),family='Helvetica')
plot(g,layout=layout.fruchterman.reingold,vertex.label=gsub('_','\n',V(g)$dname),vertex.color=V(g)$col,vertex.label.color='black',vertex.label.dist=0.5,vertex.label.family='Helvetica')
plot(g_min,layout=layout.fruchterman.reingold,vertex.label=gsub('_','\n',V(g_min)$name),vertex.label.family='Helvetica')
par(def.par)


## The function is currently defined as
function(input,filename){
	if (class(input)=='lpi'){
		tmp <- input
		class(tmp) <- 'data.frame'
		write.table(tmp,filename,sep='\t',quote=FALSE,row.names=FALSE)
	}
	else {
		cat("Input object 'input' is not of class lpi", input)
	}
  }
}
% Add one or more standard keywords, see file 'KEYWORDS' in the
% R documentation directory.
\keyword{ lpi }
