% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/localCitations.R
\name{localCitations}
\alias{localCitations}
\title{Author local citations}
\usage{
localCitations(M, results, sep = ";")
}
\arguments{
\item{M}{is a bibliographic data frame obtained by the converting function \code{\link{convert2df}}.
It is a data matrix with cases corresponding to manuscripts and variables to Field Tag in the original SCOPUS and Thomson Reuters' ISI Web of Knowledge file.}

\item{results}{is an object of \code{class} "bibliometrix". The default is \code{field = "article"}.}

\item{sep}{is the field separator character. This character separates citations in each string of CR column of the bibiographic data frame. The default is \code{sep = ";"}.}
}
\value{
an object of \code{class} "table".
}
\description{
It calculates frequency distribution of cited local authors.
}
\details{
Local citations measure how many times an author included in this collection have been cited by other authors also in the collection.
}
\examples{
 
data(scientometrics)

results <- biblioAnalysis(scientometrics)

CR <- localCitations(scientometrics, results, sep = ";")

CR[1:10]

}
\seealso{
\code{\link{citations}} function for citation frequency distribution.

\code{\link{biblioAnalysis}} function for bibliometric analysis.

\code{\link{summary}} to obtain a summary of the results.

\code{\link{plot}} to draw some useful plots of the results.
}

