% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/networkPlot.R
\name{networkPlot}
\alias{networkPlot}
\title{Plotting Bibliographic networks}
\usage{
networkPlot(NetMatrix, n = 20, Title = "Plot", type = "kamada",
  vos.path = NULL, size = FALSE, noloops = TRUE, remove.multiple = TRUE)
}
\arguments{
\item{NetMatrix}{is a network matrix obtained by the function \code{\link{biblioNetwork}}.}

\item{n}{is an integer. It indicates the number of vertices to plot.}

\item{Title}{is a character indicating the plot title.}

\item{type}{is a character object. It indicates the network map layout:

\tabular{lll}{
\code{type="circle"}\tab   \tab Circle layout\cr
\code{type="sphere"}\tab   \tab Sphere layout\cr
\code{type="mds"}\tab   \tab Multidimensional Scaling layout\cr
\code{type="fruchterman"}\tab   \tab Fruchterman-Reingold layout\cr
\code{type="kamada"}\tab   \tab  Kamada-Kawai layout\cr
\code{type="vosviewer"}\tab   \tab Network is plotted using VOSviewer software\cr}}

\item{vos.path}{is a character indicating the full path whre VOSviewer.jar is located.}

\item{size}{is logical. If TRUE the point size of each vertex is proportional to its degree.}

\item{noloops}{is logical. If TRUE loops in the network are deleted.}

\item{remove.multiple}{is logical. If TRUE multiple links are plotted using just one edge.}
}
\value{
It is a network object of the class \code{igraph}.
}
\description{
\code{networkPlot} plots a bibliographic network.
}
\details{
The function \code{\link{networkPlot}} can plot a bibliographic network previously created by \code{\link{biblioNetwork}}.
The network map can be plotted using internal R routines or using \href{http://www.vosviewer.com/}{VOSviewer} by Nees Jan van Eck and Ludo Waltman.
}
\examples{
# EXAMPLE Co-citation network

data(scientometrics)

NetMatrix <- biblioNetwork(scientometrics, analysis = "co-citation", 
network = "references", sep = ";")

net <- networkPlot(NetMatrix, n = 20, type = "kamada", Title = "Co-Citation")

}
\seealso{
\code{\link{biblioNetwork}} to compute a bibliographic network.

\code{\link{cocMatrix}} to compute a co-occurrence matrix.

\code{\link{biblioAnalysis}} to perform a bibliometric analysis.
}

