% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scopus2df.R
\name{scopus2df}
\alias{scopus2df}
\title{Convert a SCOPUS Export file into a data frame}
\usage{
scopus2df(D)
}
\arguments{
\item{D}{is a character array containing data read from a SCOPUS Export file (in bibtex format).}
}
\value{
a data frame with cases corresponding to articles and variables to Field Tag in the original SCOPUS file.
}
\description{
It converts a SCOPUS Export file and create a data frame from it, with cases corresponding to articles and variables to Field Tag in the original file.
}
\examples{
# A SCOPUS Export file can be read using \\code{\\link{readLines}} function:

# largechar <- readLines('filename.bib')

# filename.bib is a SCOPUS Export file in plain text format.
# The file have to be saved without Byte order mark (U+FEFF) at the
# beginning and EoF code at the end of file.
# The original file (exported by SCOPUS search web site) can be modified
# using an advanced text editor like Notepad++ or Emacs.

#largechar <- readLines('http://www.bibliometrix.org/datasets/scopus.bib')


#scopus_df <- scopus2df(largechar)

}
\seealso{
\code{\link{isi2df}} for converting ISI Export file (in plain text format)

Other converting.functions: \code{\link{convert2df}},
  \code{\link{isi2df}}, \code{\link{isibib2df}}
}

