% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/conceptualStructure.R
\name{conceptualStructure}
\alias{conceptualStructure}
\title{Creating and plotting conceptual structure map of a scientific field}
\usage{
conceptualStructure(M, field = "ID", quali.supp = NULL,
  quanti.supp = NULL, minDegree = 2, k.max = 5, stemming = FALSE,
  labelsize = 3)
}
\arguments{
\item{M}{is a data frame obtained by the converting function
\code{\link{convert2df}}. It is a data matrix with cases corresponding to
articles and variables to Field Tag in the original ISI or SCOPUS file.}

\item{field}{is a character object. It indicates one of the field tags of the
standard ISI WoS Field Tag codify. 
field can be equal to one of this tags:
\tabular{lll}{ 
\code{ID}\tab   \tab Keywords Plus associated by ISI or SCOPUS database\cr 
\code{DE}\tab   \tab Author's keywords\cr 
\code{ID_TM}\tab   \tab Keywords Plus stemmed through the Porter's stemming algorithm\cr
\code{DE_TM}\tab   \tab Author's Keywords stemmed through the Porter's stemming algorithm\cr
\code{TI}\tab   \tab Terms extracted from titles\cr
\code{AB}\tab   \tab Terms extracted from abstracts}}

\item{quali.supp}{is a vector indicating the indexes of the categorical supplementary variables.}

\item{quanti.supp}{is a vector indicating the indexes of the quantitative supplementary variables.}

\item{minDegree}{is an integer. It indicates the minimun occurrences of terms to analize and plot. The default value is 2.}

\item{k.max}{is an integer. It indicates the maximum numebr of cluster to keep. The default value is 5. The max value is 8.}

\item{stemming}{is logical. If TRUE the Porter's Stemming algorithm is applied to all extracted terms. The default is \code{stemming = FALSE}.}

\item{labelsize}{is an integer. It indicates the label size in the plot. Default is \code{labelsize=2}}
}
\value{
It is an object of the class \code{list} containing the following components:

\tabular{lll}{
net \tab  \tab bipartite network\cr
res.mca \tab       \tab Results of Multiple Correspondence Analysis\cr
km.res \tab      \tab Results of cluster analysis}
}
\description{
The function \code{conceptualStructure} creates a conceptual structure map of 
a scientific field performing Multiple Correspondence Analysis (MCA) and Clustering 
of a bipartite network of terms extracted from keyword, title or abstract fields.
}
\examples{
# EXAMPLE Conceptual Structure using Keywords Plus

data(scientometrics)

S <- conceptualStructure(scientometrics, field="ID_TM", stemming=TRUE, minDegree=5, k.max = 5)

}
\seealso{
\code{\link{termExtraction}} to extract terms from a textual field (abstract, title, 
author's keywords, etc.) of a bibliographic data frame.

\code{\link{biblioNetwork}} to compute a bibliographic network.

\code{\link{cocMatrix}} to compute a co-occurrence matrix.

\code{\link{biblioAnalysis}} to perform a bibliometric analysis.
}
