% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/autoplot.biclustermd_sim.R
\name{autoplot.biclustermd_sim}
\alias{autoplot.biclustermd_sim}
\title{Plot similarity measures between two consecutive biclusterings.}
\usage{
\method{autoplot}{biclustermd_sim}(object, facet = TRUE, ncol = NULL,
  ...)
}
\arguments{
\item{object}{Object of class "biclustermd_sim"}

\item{facet}{If \code{TRUE} (default), each similarity measure will be in its own plot.
if \code{FALSE}, all three similarity measures for rows and columns are 
given in one plot.}

\item{ncol}{If faceting, the number of columns to arrange the plots in.}

\item{...}{Arguments to pass to \code{ggplot2::geom_point()}}
}
\value{
A ggplot object.
}
\description{
Creates a ggplot of the three similarity measures used in \code{biclustermd::bicluster()} 
    for both row and column dimensions.
}
\examples{
data("synthetic")

bc <- biclustermd(synthetic, col_clusters = 3, row_clusters = 2,
                miss_val = mean(synthetic, na.rm = TRUE),
                miss_val_sd = sd(synthetic, na.rm = TRUE),
                col_min_num = 2, row_min_num = 2,
                col_num_to_move = 1, row_num_to_move = 1,
                max.iter = 10)
bc
autoplot(bc$Similarities, ncol = 1)
}
