% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/as.Biclust.R
\name{as.Biclust}
\alias{as.Biclust}
\title{Convert a \code{biclustermd} object to a \code{Biclust} object}
\usage{
as.Biclust(object)
}
\arguments{
\item{object}{The \code{biclustermd} object to convert to a \code{Biclust} object}
}
\value{
Returns an object of class \code{Biclust}.
}
\description{
Convert a \code{biclustermd} object to a \code{Biclust} object
}
\examples{
data("synthetic")

bc <- biclustermd(synthetic, col_clusters = 3, row_clusters = 2,
                miss_val = mean(synthetic, na.rm = TRUE),
                miss_val_sd = sd(synthetic, na.rm = TRUE),
                col_min_num = 2, row_min_num = 2,
                col_num_to_move = 1, row_num_to_move = 1,
                max.iter = 10)
bc

as.Biclust(bc)

# biclust::drawHeatmap won't work since it doesn't exclude NAs
\dontrun{biclust::drawHeatmap(synthetic, as.Biclust(bc), 6)}

# bicluster 6 is in the top right-hand corner here:
autoplot(bc)
# compare with bicust::drawHeatmap2:
biclust::drawHeatmap2(synthetic, as.Biclust(bc), 6)

# bicluster 3 is in the bottom right-hand corner here:
autoplot(bc)
# compare with bicust::drawHeatmap2:
biclust::drawHeatmap2(synthetic, as.Biclust(bc), 3)
}
