% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bigalgebra.R
\name{dcopy}
\alias{dcopy}
\title{Copy a vector.}
\usage{
dcopy(N = NULL, X, INCX = 1, Y, INCY = 1)
}
\arguments{
\item{N}{number of elements in input vector(s)}

\item{X}{double precision vector with N elements}

\item{INCX}{storage spacing between elements of DX}

\item{Y}{double precision vector with N elements}

\item{INCY}{storage spacing between elements of DY}
}
\value{
DY copy of vector DX (unchanged if N .LE. 0)
}
\description{
Copy double precision DX to double precision DY.
For I = 0 to N-1, copy DX(LX+I*INCX) to DY(LY+I*INCY),
where LX = 1 if INCX .GE. 0, else LX = 1+(1-N)*INCX, and LY is
defined in a similar way using INCY.
}
\examples{
\donttest{
set.seed(4669)
A = big.matrix(3, 2, type="double", init=1, dimnames=list(NULL, 
c("alpha", "beta")), shared=FALSE)
B = big.matrix(3, 2, type="double", init=0, dimnames=list(NULL, 
c("alpha", "beta")), shared=FALSE)

dcopy(X=A,Y=B)
A[,]-B[,]

# The big.matrix file backings will be deleted when garbage collected.
rm(A,B)
gc()
}
}
\references{
C. L. Lawson, R. J. Hanson, D. R. Kincaid and F. T. Krogh, Basic linear algebra subprograms for Fortran usage, Algorithm No. 539, Transactions on Mathematical Software 5, 3 (September 1979), pp. 308-323.
}
